% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brmultinom.R
\name{simulate.brmultinom}
\alias{simulate.brmultinom}
\title{Method for simulating a data set from \code{\link{brmultinom}} and
\code{\link{bracl}} objects}
\usage{
\method{simulate}{brmultinom}(object, ...)
}
\arguments{
\item{object}{an object of class \code{\link{brmultinom}} or
\code{\link{bracl}}.}

\item{...}{currently not used.}
}
\value{
A \code{\link{data.frame}} with \code{object$ncat} times the rows
that \code{model.frame(object)} have and the same variables. If
\code{weights} has been specified in the call that generated
\code{object}, then the simulate frequencies will populate the
weights variable. Otherwise, the resulting \code{data.frame} will
have a \code{".weights"} variable with the simulated multinomial
counts.
}
\description{
Method for simulating a data set from \code{\link{brmultinom}} and
\code{\link{bracl}} objects
}
\examples{

## Multinomial logistic regression
data("housing", package = "MASS")
houseML1 <- brmultinom(Sat ~ Infl + Type + Cont, weights = Freq,
                       data = housing, type = "ML", ref = 1)
simulate(houseML1)

## Adjacent-category logits
data("stemcell", package = "brglm2")
stemML1 <- bracl(research ~ religion + gender, weights = frequency,
                data = stemcell, type = "ML")

simulate(stemML1)

}
