% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbfs.R
\name{db_dbfs_move}
\alias{db_dbfs_move}
\title{DBFS Move}
\usage{
db_dbfs_move(
  source_path,
  destination_path,
  host = db_host(),
  token = db_token(),
  perform_request = TRUE
)
}
\arguments{
\item{source_path}{The source path of the file or directory. The path
should be the absolute DBFS path (for example, \verb{/mnt/my-source-folder/}).}

\item{destination_path}{The destination path of the file or directory. The
path should be the absolute DBFS path (for example,
\verb{/mnt/my-destination-folder/}).}

\item{host}{Databricks workspace URL, defaults to calling \code{\link[=db_host]{db_host()}}.}

\item{token}{Databricks workspace token, defaults to calling \code{\link[=db_token]{db_token()}}.}

\item{perform_request}{If \code{TRUE} (default) the request is performed, if
\code{FALSE} the httr2 request is returned \emph{without} being performed.}
}
\description{
Move a file from one location to another location within DBFS.
}
\details{
If the given source path is a directory, this call always recursively moves
all files.

When moving a large number of files, the API call will time out after
approximately 60 seconds, potentially resulting in partially moved data.
Therefore, for operations that move more than 10K files, we \strong{strongly}
discourage using the DBFS REST API. Instead, we recommend that you perform
such operations in the context of a cluster, using the File system utility
(\code{dbutils.fs}) from a notebook, which provides the same functionality without
timing out.
\itemize{
\item If the source file does not exist, this call throws an exception with
\code{RESOURCE_DOES_NOT_EXIST.}
\item If there already exists a file in the destination path, this call throws an
exception with \code{RESOURCE_ALREADY_EXISTS.}
}
}
\seealso{
Other DBFS API: 
\code{\link{db_dbfs_add_block}()},
\code{\link{db_dbfs_close}()},
\code{\link{db_dbfs_create}()},
\code{\link{db_dbfs_delete}()},
\code{\link{db_dbfs_get_status}()},
\code{\link{db_dbfs_list}()},
\code{\link{db_dbfs_mkdirs}()},
\code{\link{db_dbfs_put}()},
\code{\link{db_dbfs_read}()}
}
\concept{DBFS API}
