% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uc-volumes.R
\name{db_uc_volumes_get}
\alias{db_uc_volumes_get}
\title{Get Volume (Unity Catalog)}
\usage{
db_uc_volumes_get(
  catalog,
  schema,
  volume,
  include_browse = TRUE,
  host = db_host(),
  token = db_token(),
  perform_request = TRUE
)
}
\arguments{
\item{catalog}{Parent catalog of volume}

\item{schema}{Parent schema of volume}

\item{volume}{Volume name.}

\item{include_browse}{Whether to include volumes in the response for which
the principal can only access selective metadata for.}

\item{host}{Databricks workspace URL, defaults to calling \code{\link[=db_host]{db_host()}}.}

\item{token}{Databricks workspace token, defaults to calling \code{\link[=db_token]{db_token()}}.}

\item{perform_request}{If \code{TRUE} (default) the request is performed, if
\code{FALSE} the httr2 request is returned \emph{without} being performed.}
}
\value{
List
}
\description{
Get Volume (Unity Catalog)
}
\seealso{
Other Unity Catalog Volume Management: 
\code{\link{db_uc_volumes_create}()},
\code{\link{db_uc_volumes_delete}()},
\code{\link{db_uc_volumes_list}()},
\code{\link{db_uc_volumes_update}()}
}
\concept{Unity Catalog Volume Management}
