% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readLines.R
\name{readLines}
\alias{readLines}
\title{Read text lines from a file}
\usage{
readLines(con, n = -1, ok, warn, encoding, skipNul)
}
\arguments{
\item{con}{A character string of the path to a file. Throws an error if a connection object is passed.}

\item{n}{integer. The number of lines to read. A negative number means read
all the lines in the file.}

\item{ok}{Ignored, with a warning.}

\item{warn}{Ignored, with a warning.}

\item{encoding}{Ignored, with a warning.}

\item{skipNul}{Ignored, with a warning.}
}
\value{
A UTF-8 encoded character vector of the lines in the file.
}
\description{
This is a drop in replacement for \code{\link[base:readLines]{base::readLines()}} with restricted
functionality. Compared to \code{\link[base:readLines]{base::readLines()}} it:
\itemize{
\item Only works with file paths, not connections.
\item Assumes the files are always UTF-8 encoded.
\item Does not warn or skip embedded nulls, they will likely crash R.
\item Does not warn if the file is missing the end of line character.
\item The arguments \code{ok}, \code{warn}, \code{encoding} and \code{skipNul} are ignored, with a warning.
}
}
\examples{
authors_file <- file.path(R.home("doc"), "AUTHORS")
data <- readLines(authors_file)

# Trying to use connections throws an error
con <- file(authors_file)
try(readLines(con))
close(con)

# Trying to use unsupported args throws a warning
data <- readLines(authors_file, encoding = "UTF-16")
}
\seealso{
\code{\link[=writeLines]{writeLines()}}
}
