% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Landscape-Methods.R
\name{simulateInitialPartition}
\alias{simulateInitialPartition}
\title{simulateInitialPartition Method}
\usage{
simulateInitialPartition(n = 500, prop = 0.4, range = 10, xmin = 0,
  xmax = 5000, ymin = 0, ymax = 5000)
}
\arguments{
\item{n}{Numeric, numbers of cells}

\item{prop}{Numeric [0,1] toxic cells proportion}

\item{range}{Aggregation parameter (range of the spatial Exponential covariance of Gaussian process)}

\item{xmin}{x-axis left coordinates in space unit (see projections_briskaR)}

\item{xmax}{x-axis right coordinates in space unit (see projections_briskaR)}

\item{ymin}{y-axis bottom coordinates in space unit (see projections_briskaR)}

\item{ymax}{y-axis top coordinates in space unit (see projections_briskaR)}
}
\value{
An S4 \link{Landscape} object with \code{n} fields, \code{prop} pourcentage of toxic fields of size (xmin,xmax) (ymin,ymax)
}
\description{
This function creates an object \link{Landscape} and simulates a landscape with neutral and source fields.
}
\details{
In the function the first step is a binomial point process to simulate a SpatialPointsDataFrame with sources and neutral marks, which depends on the aggregation parameter.
The second step of the function is the Voronoi tesselation from the simulated points and returns a SpatialPolygonsDataFrame.
}
\examples{
\dontrun{
# Simulate a 5000m x 5000m landscape with 500 cells (e.g. fields)
# whose 40\% (200 cells) are sources. 
# The projection by default is Lambert93 projection.
land <- simulateInitialPartition(n=500,prop=0.4,range=10,xmin=0,xmax=5000,ymin=0,ymax=5000)
plot(land)
}
}

