% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/landscape_toxicIntensity.R
\name{toxicIntensity}
\alias{toxicIntensity}
\title{toxicIntendity function wrapping dispersal and exposure}
\usage{
toxicIntensity(
  object,
  sf,
  size_raster = 2^10,
  tolerance_square = 0.1,
  kernel = "NIG",
  kernel.options = list(a1 = 0.2073, a2 = 0.2073, b1 = 0.3971, b2 = 0.3971, b3 =
    0.0649, theta = 0),
  loss = NULL,
  beta = 0.4,
  nbr_cores = 1,
  squared_frame = NULL,
  quiet = FALSE
)
}
\arguments{
\item{object}{sf or SpatialPolygonsDataFrame. A simple feature of class \link[sf]{sf} or \link[sp]{SpatialPolygonsDataFrame}}

\item{sf}{sf. And object of class `sf` on which exposure is computed from the previous
list of raster by patch `RasterStack_dispersal`. See \link[sf]{sf} for details.}

\item{size_raster}{integer. Raster size (default = 2^10)}

\item{tolerance_square}{numeric. Tolerance rate to test if an sf set is squared}

\item{kernel}{string. Dispersion kernel, function name (default = NIG)}

\item{kernel.options}{list. Parameters list for the kernel function}

\item{loss}{numeric. Numeric vector to applied a loss on exposure cells.}

\item{beta}{numeric. toxic adherence parameter between 0 and 1 (default = 0.4).}

\item{nbr_cores}{integer. Parameters for parallel computing: the
number of cores to use, i.e. at most how many child processes
will be run simultaneously. Default is \code{1} (non parallel).}

\item{squared_frame}{sf. Select the sf to be considered as frame to rasterized.
Default is `NULL`, and `object` is used.}

\item{quiet}{boolean. Set `TRUE` to remove progress bar.}
}
\description{
toxicIntendity function wrapping dispersal and exposure
}
\details{
The dispersal of contaminants is implemented by rastering the landscape and
 by computing the convolution between sources emissions and a dispersal kernel.

The dispersion kernel by default is Normal Inverse Gaussian kernel ("NIG" function). 
Currently, two others are implemented "geometric" (with parameter \code{a}) and "2Dt" kernels 
(with parameters \code{a}, \code{b}, \code{c1}, \code{c2}).

Local intensity depends of \code{beta} and \code{alpha} parameters. Beta represents the toxic adherence between [0,1].
Alpha represents a list of parameters of the lost of toxic particules due to covariates (precipitation).
There are two configurations to integrate the loss in the function : 
(i) simulating covariate (simulate=TRUE) or (ii) uploading covariate (simulate=FALSE).
The covariate is linked to the loss by a linear regression with paramaters minalpha, maxalpha, covariate_threshold.
}
