% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brm_prior_template.R
\name{brm_prior_template}
\alias{brm_prior_template}
\title{Label template for informative prior archetypes}
\usage{
brm_prior_template(archetype)
}
\arguments{
\item{archetype}{An informative prior archetype generated by a function
like \code{\link[=brm_archetype_successive_cells]{brm_archetype_successive_cells()}}.}
}
\value{
A \code{tibble} with one row per fixed effect parameter and columns
to map Stan code to each parameter. After manually writing Stan code in
the \code{code} column of the template, you can supply the result
to the \code{label} argument of \code{\link[=brm_prior_archetype]{brm_prior_archetype()}} to build a
\code{brms} prior for your model.
}
\description{
Template for the \code{label} argument of \code{\link[=brm_prior_archetype]{brm_prior_archetype()}}.
}
\details{
The \code{label} argument of \code{\link[=brm_prior_archetype]{brm_prior_archetype()}} is a
\code{tibble} which maps Stan code for univariate priors
to fixed effect parameters in the model. Usually this \code{tibble} is
built gradually using multiple calls to \code{\link[=brm_prior_label]{brm_prior_label()}},
but occasionally it is more convenient to begin with a full template
and manually write Stan code in the \code{code} column.
\code{\link[=brm_prior_template]{brm_prior_template()}} creates this template.
}
\section{Prior labeling}{

Informative prior archetypes use a labeling scheme to assign priors
to fixed effects. How it works:

\if{html}{\out{<div class="sourceCode">}}\preformatted{1. First, assign the prior of each parameter a collection
  of labels from the data. This can be done manually or with
  successive calls to [brm_prior_label()].
2. Supply the labeling scheme to [brm_prior_archetype()].
  [brm_prior_archetype()] uses attributes of the archetype
  to map labeled priors to their rightful parameters in the model.
}\if{html}{\out{</div>}}

For informative prior archetypes, this process is much more convenient
and robust than manually calling \code{\link[brms:set_prior]{brms::set_prior()}}.
However, it requires an understanding of how the labels of the priors
map to parameters in the model. This mapping varies from archetype
to archetype, and it is documented in the help pages of
archetype-specific functions such as \code{\link[=brm_archetype_successive_cells]{brm_archetype_successive_cells()}}.
}

\examples{
set.seed(0L)
data <- brm_simulate_outline(
  n_group = 2,
  n_patient = 100,
  n_time = 3,
  rate_dropout = 0,
  rate_lapse = 0
) |>
  dplyr::mutate(response = rnorm(n = dplyr::n())) |>
  brm_simulate_continuous(names = c("biomarker1", "biomarker2")) |>
  brm_simulate_categorical(
    names = c("status1", "status2"),
    levels = c("present", "absent")
  )
archetype <- brm_archetype_successive_cells(data)
label <- brm_prior_template(archetype)
label$code <- c(
  "normal(1, 1)",
  "normal(1, 2)",
  "normal(1, 3)",
  "normal(2, 1)",
  "normal(2, 2)",
  "normal(2, 3)"
)
brm_prior_archetype(label = label, archetype = archetype)
}
\seealso{
Other priors: 
\code{\link{brm_prior_archetype}()},
\code{\link{brm_prior_label}()},
\code{\link{brm_prior_simple}()}
}
\concept{priors}
