% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brm_archetype.R
\name{summary.brms_mmrm_archetype}
\alias{summary.brms_mmrm_archetype}
\title{Summarize an informative prior archetype.}
\usage{
\method{summary}{brms_mmrm_archetype}(object, message = TRUE, ...)
}
\arguments{
\item{object}{The informative prior archetype to summarize.}

\item{message}{TRUE to print an informative message about the archetype
and invisibly return a character vector of equations. \code{FALSE}
to forgo verbose messages and non-invisibly return the equations.}

\item{...}{Not used, but required for S3 methods that inherit from
the base generic \code{\link[=summary]{summary()}}.}
}
\value{
Return a character vector with linear equations
that map model parameters to marginal means. If the \code{message}
argument is \code{TRUE} (default) then this character vector is returned
invisibly and a verbose description of the equations is printed.
}
\description{
For an informative prior archetype, show
the transformation from model parameters to marginal means.
}
\examples{
data <- brm_simulate_outline(
  n_group = 2,
  n_patient = 100,
  n_time = 4,
  rate_dropout = 0,
  rate_lapse = 0
) |>
  dplyr::mutate(response = rnorm(n = dplyr::n())) |>
  brm_data_change() |>
  brm_simulate_continuous(names = c("biomarker1", "biomarker2")) |>
  brm_simulate_categorical(
    names = c("status1", "status2"),
    levels = c("present", "absent")
  )
dplyr::select(
  data,
  group,
  time,
  patient,
  starts_with("biomarker"),
  starts_with("status")
)
archetype <- brm_archetype_successive_cells(data)
equations <- summary(archetype)
print(equations)
summary(archetype, message = FALSE)
}
\keyword{internal}
