% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/data.docu.R
\docType{data}
\name{kidney}
\alias{kidney}
\title{Infections in kidney patients}
\format{A dataframe of 76 observations containing information on the following 7 variables.
\describe{
 \item{time}{The time to first or second recurrence of the infection, or the time of censoring}
 \item{recur}{A factor of levels \code{1} or \code{2} indicating if the infection recurred for the first or second time for this patient}
 \item{censored}{Either \code{0} or \code{1}, where \code{0} indicates no censoring of recurrence time and \code{1} indicates right censoring}
 \item{patient}{The patient number}
 \item{age}{The age of the patient}
 \item{sex}{The sex of the patient}
 \item{disease}{A factor of levels \code{other, GN, AN}, and \code{PKD} specifiying the type of disease}
}}
\source{
McGilchrist, C. A., & Aisbett, C. W. (1991). Regression with frailty in survival analysis.
  \emph{Biometrics, 47(2)}, 461-466.
}
\usage{
kidney
}
\description{
This dataset, originally discussed in McGilchrist and Aisbett (1991), describes the first and second (possibly right censored) recurrence time of
infection in kideny patients using portable dialysis equipment. In addition, information on the risk variables age, sex and disease type is provided.
}
\examples{
\dontrun{
## performing surivival analysis using the "weibull" family
## time | cens indicates which values in variable time are right censored
fit_k1 <- brm(time | cens(censored) ~ age + sex + disease, data = kidney,
              family = "weibull")
summary(fit_k1)
plot(fit_k1)

## adding random intercepts over patients and using weakly informative priors
## for regression parameters and standard deviations of random effects
fit_k2 <- brm(time | cens(censored) ~ age + sex + disease + (1|patient),
              data = kidney, prior = list(sd = "uniform(0,20)"),
              family = "weibull", inits = "0", silent = TRUE)
summary(fit_k2)
plot(fit_k2)
}
}
\keyword{datasets}

