% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brmsfit-methods.R, R/generics.R
\name{marginal_smooths.brmsfit}
\alias{marginal_smooths}
\alias{marginal_smooths.brmsfit}
\title{Display Smooth Terms}
\usage{
\method{marginal_smooths}{brmsfit}(x, smooths = NULL, probs = c(0.025,
  0.975), resolution = 100, too_far = 0, ...)

marginal_smooths(x, ...)
}
\arguments{
\item{x}{An object usually of class \code{brmsfit}.}

\item{smooths}{Optional character vector of smooth terms
to display. If \code{NULL} (the default) all smooth terms
are shown.}

\item{probs}{The quantiles to be used in the computation of credible
intervals (defaults to 2.5 and 97.5 percent quantiles)}

\item{resolution}{Number of support points used to generate 
the plots. Higher resolution leads to smoother plots. 
Defaults to \code{100}. If \code{contour} is \code{TRUE},
this implies \code{10000} support points for interaction terms,
so it might be necessary to reduce \code{resolution} 
when only few RAM is available.}

\item{too_far}{For contour plots only: Grid points that are too 
far away from the actual data points can be excluded from the plot. 
\code{too_far} determines what is too far. The grid is scaled into 
the unit square and then grid points more than \code{too_far} 
from the predictor variables are excluded. By default, all
grid points are used. Ignored for non-contour plots.}

\item{...}{Currently ignored.}
}
\value{
For the \code{brmsfit} method, 
an object of class \code{brmsMarginalEffects}. See
\code{\link[brms:marginal_effects]{marginal_effects}} for 
more details and documentation of the related plotting function.
}
\description{
Display smooth \code{s} and \code{t2} terms of models
fitted with \pkg{brms}.
}
\details{
Two-dimensional smooth terms will be visualized using
  contour plots.
}
\examples{
\dontrun{
set.seed(0) 
dat <- mgcv::gamSim(1, n = 200,scale = 2)
fit <- brm(y ~ s(x0) + s(x1) + s(x2) + s(x3), data = dat)
# show all smooth terms
plot(marginal_smooths(fit), rug = TRUE, ask = FALSE)
# show only the smooth term s(x2)
plot(marginal_smooths(fit, smooths = "s(x2)"), ask = FALSE)

# fit and plot a two-dimensional smooth term
fit2 <- brm(y ~ t2(x0, x2), data = dat)
ms <- marginal_smooths(fit2)
plot(ms, stype = "contour")
plot(ms, stype = "raster")
}

}

