% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correlations.R
\name{cor_sar}
\alias{cor_sar}
\alias{cor_lagsar}
\alias{cor_errorsar}
\title{Spatial simultaneous autoregressive (SAR) structures}
\usage{
cor_sar(W, type = c("lag", "error"))

cor_lagsar(W)

cor_errorsar(W)
}
\arguments{
\item{W}{An object specifying the spatial weighting matrix.
Can be either the spatial weight matrix itself or an 
object of class \code{listw} or \code{nb}, from which
the spatial weighting matrix can be computed.}

\item{type}{Type of the SAR structure. Either \code{"lag"} 
(for SAR of the response values) or \code{"error"} 
(for SAR of the residuals).}
}
\value{
An object of class \code{cor_sar} to be used in calls to
  \code{\link{brm}}.
}
\description{
These functions are constructors for the \code{cor_sar} class
implementing spatial simultaneous autoregressive structures.
The \code{lagsar} structure implements SAR of the response values:
\deqn{y = \rho W y + \eta + e}
The \code{errorsar} structure implements SAR of the residuals:
\deqn{y = \eta + u, u = \rho W u + e}
In the above equations, \eqn{\eta} is the predictor term and
\eqn{e} are independent normally or t-distributed residuals.
}
\details{
Currently, only families \code{gaussian} and \code{student} 
  support SAR structures.
}
\examples{
\dontrun{
data(oldcol, package = "spdep")
fit1 <- brm(CRIME ~ INC + HOVAL, data = COL.OLD, 
            autocor = cor_lagsar(COL.nb), 
            chains = 2, cores = 2)
summary(fit1)
plot(fit1)

fit2 <- brm(CRIME ~ INC + HOVAL, data = COL.OLD, 
            autocor = cor_errorsar(COL.nb), 
            chains = 2, cores = 2)
summary(fit2)
plot(fit2)
}

}
