% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brmsfit-methods.R
\name{loo.brmsfit}
\alias{loo.brmsfit}
\alias{loo}
\alias{LOO}
\alias{LOO.brmsfit}
\title{Efficient approximate leave-one-out cross-validation (LOO)}
\usage{
\method{loo}{brmsfit}(x, ..., compare = TRUE, resp = NULL,
  pointwise = FALSE, reloo = FALSE, k_threshold = 0.7,
  reloo_args = list(), model_names = NULL)
}
\arguments{
\item{x}{A \code{brmsfit} object.}

\item{...}{More \code{brmsfit} objects or further arguments
passed to the underlying post-processing functions.
In particular, see \code{\link{extract_draws}} for further
supported arguments.}

\item{compare}{A flag indicating if the information criteria
of the models should be compared to each other
via \code{\link{loo_compare}}.}

\item{resp}{Optional names of response variables. If specified, predictions
are performed only for the specified response variables.}

\item{pointwise}{A flag indicating whether to compute the full
log-likelihood matrix at once or separately for each observation. 
The latter approach is usually considerably slower but 
requires much less working memory. Accordingly, if one runs 
into memory issues, \code{pointwise = TRUE} is the way to go.}

\item{reloo}{Logical; Indicate whether \code{\link{reloo}} 
should be applied on problematic observations. Defaults to \code{FALSE}.}

\item{k_threshold}{The threshold at which pareto \eqn{k} 
estimates are treated as problematic. Defaults to \code{0.7}. 
Only used if argument \code{reloo} is \code{TRUE}.
See \code{\link[loo:pareto_k_ids]{pareto_k_ids}} for more details.}

\item{reloo_args}{Optional \code{list} of additional arguments passed to
\code{\link{reloo}}.}

\item{model_names}{If \code{NULL} (the default) will use model names 
derived from deparsing the call. Otherwise will use the passed 
values as model names.}
}
\value{
If just one object is provided, an object of class \code{loo}. 
 If multiple objects are provided, an object of class \code{loolist}.
}
\description{
Perform approximate leave-one-out cross-validation based 
on the posterior likelihood using the \pkg{loo} package.
For more details see \code{\link[loo:loo]{loo}}.
}
\details{
See \code{\link{loo_compare}} for details on model comparisons.
 For \code{brmsfit} objects, \code{LOO} is an alias of \code{loo}.
 Use method \code{\link{add_criterion}} to store
 information criteria in the fitted model object for later usage.
}
\examples{
\dontrun{
# model with population-level effects only
fit1 <- brm(rating ~ treat + period + carry,
            data = inhaler)
(loo1 <- loo(fit1))

# model with an additional varying intercept for subjects
fit2 <- brm(rating ~ treat + period + carry + (1|subject),
            data = inhaler)
(loo2 <- loo(fit2))   

# compare both models
loo_compare(loo1, loo2)                      
}

}
\references{
Vehtari, A., Gelman, A., & Gabry J. (2016). Practical Bayesian model
evaluation using leave-one-out cross-validation and WAIC. In Statistics 
and Computing, doi:10.1007/s11222-016-9696-4. arXiv preprint arXiv:1507.04544.

Gelman, A., Hwang, J., & Vehtari, A. (2014). 
Understanding predictive information criteria for Bayesian models. 
Statistics and Computing, 24, 997-1016.

Watanabe, S. (2010). Asymptotic equivalence of Bayes cross validation 
and widely applicable information criterion in singular learning theory. 
The Journal of Machine Learning Research, 11, 3571-3594.
}
\author{
Paul-Christian Buerkner \email{paul.buerkner@gmail.com}
}
