% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brmsfit-methods.R
\name{predictive_interval.brmsfit}
\alias{predictive_interval.brmsfit}
\alias{predictive_interval}
\title{Predictive Intervals}
\usage{
\method{predictive_interval}{brmsfit}(object, prob = 0.9, ...)
}
\arguments{
\item{object}{An \R object of class \code{brmsfit}.}

\item{prob}{A number p (0 < p < 1) indicating the desired probability mass to
include in the intervals. Defaults to \code{0.9}.}

\item{...}{Further arguments passed to \code{\link{posterior_predict}}.}
}
\value{
A matrix with 2 columns for the lower and upper bounds of the
  intervals, respectively, and as many rows as observations being predicted.
}
\description{
Compute intervals from the posterior predictive distribution.
}
\examples{
\dontrun{
fit <- brm(count ~ zBase, data = epilepsy, family = poisson())
predictive_interval(fit)
}

}
