% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brmsformula.R
\name{brmsformula-helpers}
\alias{brmsformula-helpers}
\alias{bf-helpers}
\alias{nlf}
\alias{lf}
\alias{set_nl}
\alias{set_rescor}
\alias{set_mecor}
\title{Linear and Non-linear formulas in \pkg{brms}}
\usage{
nlf(formula, ..., flist = NULL, dpar = NULL, resp = NULL, loop = NULL)

lf(
  ...,
  flist = NULL,
  dpar = NULL,
  resp = NULL,
  center = NULL,
  cmc = NULL,
  sparse = NULL,
  decomp = NULL
)

set_nl(nl = TRUE, dpar = NULL, resp = NULL)

set_rescor(rescor = TRUE)

set_mecor(mecor = TRUE)
}
\arguments{
\item{formula}{Non-linear formula for a distributional parameter.
The name of the distributional parameter can either be specified
on the left-hand side of \code{formula} or via argument \code{dpar}.}

\item{...}{Additional \code{formula} objects to specify 
predictors of non-linear and distributional parameters. 
Formulas can either be named directly or contain
names on their left-hand side. 
The following are distributional parameters of specific families
(all other parameters are treated as non-linear parameters):
\code{sigma} (residual standard deviation or scale of
the \code{gaussian}, \code{student}, \code{skew_normal}, 
\code{lognormal} \code{exgaussian}, and \code{asym_laplace} families);
\code{shape} (shape parameter of the \code{Gamma},
\code{weibull}, \code{negbinomial}, and related
zero-inflated / hurdle families); \code{nu} (degrees of freedom 
parameter of the \code{student} and \code{frechet} families);
\code{phi} (precision parameter of the \code{beta} 
and \code{zero_inflated_beta} families);
\code{kappa} (precision parameter of the \code{von_mises} family);
\code{beta} (mean parameter of the exponential component
of the \code{exgaussian} family);
\code{quantile} (quantile parameter of the \code{asym_laplace} family);
\code{zi} (zero-inflation probability); 
\code{hu} (hurdle probability);
\code{zoi} (zero-one-inflation probability);
\code{coi} (conditional one-inflation probability);
\code{disc} (discrimination) for ordinal models;
\code{bs}, \code{ndt}, and \code{bias} (boundary separation,
non-decision time, and initial bias of the \code{wiener}
diffusion model).
By default, distributional parameters are modeled 
on the log scale if they can be positive only or on the 
logit scale if the can only be within the unit interval.
See 'Details' for more explanation.}

\item{flist}{Optional list of formulas, which are treated in the 
same way as formulas passed via the \code{...} argument.}

\item{dpar}{Optional character string specifying the distributional 
parameter to which the formulas passed via \code{...} and
\code{flist} belong.}

\item{resp}{Optional character string specifying the response 
variable to which the formulas passed via \code{...} and
\code{flist} belong. Only relevant in multivariate models.}

\item{loop}{Logical; Only used in non-linear models.
Indicates if the computation of the non-linear formula should be 
done inside (\code{TRUE}) or outside (\code{FALSE}) a loop
over observations. Defaults to \code{TRUE}.}

\item{center}{Logical; Indicates if the population-level design
matrix should be centered, which usually increases sampling efficiency.
See the 'Details' section for more information.
Defaults to \code{TRUE} for distributional parameters
and to \code{FALSE} for non-linear parameters.}

\item{cmc}{Logical; Indicates whether automatic cell-mean coding
should be enabled when removing the intercept by adding \code{0} 
to the right-hand of model formulas. Defaults to \code{TRUE} to 
mirror the behavior of standard \R formula parsing.}

\item{sparse}{Logical; indicates whether the population-level design matrices
should be treated as sparse (defaults to \code{FALSE}). For design matrices
with many zeros, this can considerably reduce required memory. Sampling
speed is currently not improved or even slightly decreased.}

\item{decomp}{Optional name of the decomposition used for the 
population-level design matrix. Defaults to \code{NULL} that is
no decomposition. Other options currently available are
\code{"QR"} for the QR decomposition that helps in fitting models
with highly correlated predictors.}

\item{nl}{Logical; Indicates whether \code{formula} should be
treated as specifying a non-linear model. By default, \code{formula} 
is treated as an ordinary linear model formula.}

\item{rescor}{Logical; Indicates if residual correlation between
the response variables should be modeled. Currently this is only
possible in multivariate \code{gaussian} and \code{student} models.
Only relevant in multivariate models.}

\item{mecor}{Logical; Indicates if correlations between latent variables
defined by \code{\link{me}} terms should be modeled. Defaults to \code{TRUE}.}
}
\value{
For \code{lf} and \code{nlf} a \code{list} that can be 
  passed to \code{\link[brms:brmsformula]{brmsformula}} or added 
  to an existing \code{brmsformula} or \code{mvbrmsformula} object. 
  For \code{set_nl} and \code{set_rescor} a logical value that can be 
  added to an existing \code{brmsformula} or \code{mvbrmsformula} object.
}
\description{
Helper functions to specify linear and non-linear
formulas for use with \code{\link[brms:brmsformula]{brmsformula}}.
}
\examples{
# add more formulas to the model
bf(y ~ 1) + 
  nlf(sigma ~ a * exp(b * x)) + 
  lf(a ~ x, b ~ z + (1|g)) +
  gaussian()

# specify 'nl' later on
bf(y ~ a * inv_logit(x * b)) +
  lf(a + b ~ z) +
  set_nl(TRUE)
  
# specify a multivariate model
bf(y1 ~ x + (1|g)) + 
  bf(y2 ~ z) +
  set_rescor(TRUE)
}
\seealso{
\code{\link{brmsformula}}, \code{\link{mvbrmsformula}}
}
