% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brmsfit-helpers.R
\name{posterior_table}
\alias{posterior_table}
\title{Table Creation for Posterior Samples}
\usage{
posterior_table(x, levels = NULL)
}
\arguments{
\item{x}{A matrix of posterior samples where rows 
indicate samples and columns indicate parameters.}

\item{levels}{Optional values of possible posterior values.
Defaults to all unique values in \code{x}.}
}
\value{
A matrix where rows indicate parameters 
 and columns indicate the unique values of 
 posterior samples.
}
\description{
Create a table for unique values of posterior samples. 
This is usually only useful when summarizing predictions 
of ordinal models.
}
\examples{
\dontrun{
fit <- brm(rating ~ period + carry + treat, 
           data = inhaler, family = cumulative())
pr <- predict(fit, summary = FALSE)
posterior_table(pr)
}
 
}
