% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brmsfit-methods.R, R/generics.R
\name{prior_samples.brmsfit}
\alias{prior_samples.brmsfit}
\alias{prior_samples}
\title{Extract prior samples}
\usage{
\method{prior_samples}{brmsfit}(x, pars = NA, ...)

prior_samples(x, pars = NA, ...)
}
\arguments{
\item{x}{An \code{R} object typically of class \code{brmsfit}}

\item{pars}{Names of parameters for which prior samples should be returned, 
as given by a character vector or regular expressions.
By default, all prior samples are extracted}

\item{...}{Currently ignored}
}
\value{
A data frame containing the prior samples.
}
\description{
Extract prior samples of specified parameters
}
\details{
To make use of this function, 
 the model must contain samples of prior distributions.
 This can be ensured by setting \code{sample_prior = TRUE} 
 in function \code{brm}.
 Currently there are methods for \code{brmsfit} objects.
}
\examples{
\dontrun{
fit <- brm(rating ~ treat + period + carry + (1|subject), 
           data = inhaler, family = "cumulative", 
           prior = set_prior("normal(0,2)", class = "b"), 
           sample_prior = TRUE)

# extract all prior samples
samples1 <- prior_samples(fit)
head(samples1)

# extract prior samples for the population-level effects of 'treat'
samples2 <- prior_samples(fit, "b_treat")
head(samples2)
}

}
\author{
Paul-Christian Buerkner \email{paul.buerkner@gmail.com}
}
