% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kr.R
\name{kr}
\alias{kr}
\title{Kasim-Raudenbush sampler for two-level normal model}
\usage{
kr(y, x, g, control = control_kr())
}
\arguments{
\item{y}{Vector with outcome value}

\item{x}{Matrix with predictor value}

\item{g}{Vector with group values}

\item{control}{A list created by \code{\link[=control_kr]{control_kr()}} that sets algorithmic options
of the sampler and correlation model.}
}
\value{
An object of class \code{kr}, basically a list with components:\preformatted{* `beta`  Fixed effects
* `omega` Variance-covariance of random effects
* `sigma2_j` Residual variance per group
* `sigma2` Average residual variance
* `sample` Descriptive statistics about the data
* `imp`   Numeric matrix with `nimp` multiple imputations.
* `mod`   A list of objects of class [coda::mcmc()]
}

The number of rows in \code{imp} is equal to the number of missing values in the
outcome vector \code{y}. The number of columns equals \code{nimp}.
}
\description{
Simulates posterior distributions of parameters from a two-level
normal model with heterogeneous within-cluster variances
(Kasim and Raudenbush, 1998). Imputations can be drawn as an
extra step to the algorithm.
}
\details{
The speed of the Kasim-Raudenbush sampler is almost
independent of the number of random effect, and foremost depends
on the total number of iterations.

The defaults \code{start = 100}, \code{n = 200} and \code{thin = 1} provide 200 parameter
draws with a \emph{reasonable} approximation to the variance-covariance
matrix of the random effects.

For a closer approximations with 200 draws set \code{control = control_kr(thin = 10)}
(\emph{better}) or \code{thin = 20} (\emph{best}), at the expense of a linear increase in calculation
time. Drawing fewer than 50 observations is not recommended, and such
results are best treated as \emph{indicative}.

It is possible to draw multiple imputations by setting the \code{nimp} parameter.
For example, to draw five imputations for each missing outcome specify
\code{control = control_kr(nimp = 5)}.
}
\references{
Kasim RM, Raudenbush SW. (1998). Application of Gibbs sampling to nested
variance components models with heterogeneous within-group variance. Journal
of Educational and Behavioral Statistics, 23(2), 93--116.
}
\author{
Stef van Buuren, based on \code{\link[mice:mice.impute.2l.norm]{mice::mice.impute.2l.norm()}}
}
