% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select_helpers.R
\name{select_helpers}
\alias{select_helpers}
\alias{all_continuous}
\alias{all_dichotomous}
\alias{all_categorical}
\alias{all_interaction}
\alias{all_ran_pars}
\alias{all_ran_vals}
\alias{all_intercepts}
\alias{all_contrasts}
\title{Select helper functions}
\usage{
all_continuous()

all_dichotomous()

all_categorical(dichotomous = TRUE)

all_interaction()

all_ran_pars()

all_ran_vals()

all_intercepts()

all_contrasts(contrasts_type = NULL)
}
\arguments{
\item{dichotomous}{Logical indicating whether to include dichotomous variables.
Default is \code{TRUE}}

\item{contrasts_type}{type of contrast to select. When \code{NULL}, all variables with a
contrast will be selected. Default is \code{NULL}.  Select among contrast types
\code{c("treatment", "sum", "poly", "helmert", "other")}}
}
\value{
A character vector of column names selected
}
\description{
Set of functions to supplement the {tidyselect} set of
functions for selecting columns of data frames (and other items as well).
\itemize{
\item \code{all_continuous()} selects continuous variables
\item \code{all_categorical()} selects categorical (including \code{"dichotomous"}) variables
\item \code{all_dichotomous()} selects only type \code{"dichotomous"}
\item \code{all_interaction()} selects interaction terms from a regression model
\item \code{all_intercepts()} selects intercept terms from a regression model
\item \code{all_contrasts()} selects variables in regression model based on their type
of contrast
\item \code{all_ran_pars()} and \code{all_ran_vals()} for random-effect parameters and
values from a mixed model
(see \code{vignette("broom_mixed_intro", package = "broom.mixed")})
}
}
\examples{
glm(response ~ age * trt + grade, gtsummary::trial, family = binomial) \%>\%
  tidy_plus_plus(exponentiate = TRUE, include = all_categorical())

glm(response ~ age + trt + grade + stage,
    gtsummary::trial,
    family = binomial,
    contrasts = list(trt = contr.SAS, grade = contr.sum, stage = contr.poly)) \%>\%
tidy_plus_plus(exponentiate = TRUE,
               include = all_contrasts(c("treatment", "sum")))
}
