% Generated by roxygen2 (4.0.2): do not edit by hand
\name{tidy.map}
\alias{tidy.map}
\title{Tidy method for map objects.}
\usage{
\method{tidy}{map}(x, ...)
}
\arguments{
\item{x}{map object}

\item{...}{not used by this method}
}
\description{
This function turns a map into a data frame.
}
\details{
This code and documentation originated in ggplot2, but was called "fortify."
In broom, "fortify" became "augment", which is reserved for functions that *add*
columns to existing data (based on a model fit, for example) so these functions
were renamed as "tidy."
}
\examples{
if (require("maps") && require("ggplot2")) {
    ca <- map("county", "ca", plot = FALSE, fill = TRUE)
    head(tidy(ca))
    qplot(long, lat, data = ca, geom = "polygon", group = group)

    tx <- map("county", "texas", plot = FALSE, fill = TRUE)
    head(tidy(tx))
    qplot(long, lat, data = tx, geom = "polygon", group = group,
          colour = I("white"))
}
}

