% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/stats_tidiers.R
\name{tidy.pairwise.htest}
\alias{tidy.pairwise.htest}
\title{tidy a pairwise hypothesis test}
\usage{
\method{tidy}{pairwise.htest}(x, ...)
}
\arguments{
\item{x}{a "pairwise.htest" object}

\item{...}{extra arguments (not used)}
}
\value{
A data frame with one row per group/group comparison, with columns
  \item{group1}{First group being compared}
  \item{group2}{Second group being compared}
  \item{p.value}{(Adjusted) p-value of comparison}
}
\description{
Tidy a pairwise.htest object, containing (adjusted) p-values for multiple
pairwise hypothesis tests.
}
\details{
Note that in one-sided tests, the alternative hypothesis of each
test can be stated as "group1 is greater/less than group2".

Note also that the columns of group1 and group2 will always be a factor,
even if the original input is (e.g.) numeric.
}
\examples{
attach(airquality)
Month <- factor(Month, labels = month.abb[5:9])
ptt <- pairwise.t.test(Ozone, Month)
tidy(ptt)

attach(iris)
ptt2 <- pairwise.t.test(Petal.Length, Species)
tidy(ptt2)

tidy(pairwise.t.test(Petal.Length, Species, alternative = "greater"))
tidy(pairwise.t.test(Petal.Length, Species, alternative = "less"))

tidy(pairwise.wilcox.test(Petal.Length, Species))
}
\seealso{
\link{pairwise.t.test}, \link{pairwise.wilcox.test}
}

