% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/orcutt_tidiers.R
\name{orcutt_tidiers}
\alias{glance_orcutt}
\alias{orcutt_tidiers}
\alias{tidy_orcutt}
\title{Tidiers for Cochrane Orcutt object}
\usage{
tidy_orcutt(x, ...)

glance_orcutt(x, ...)
}
\arguments{
\item{x}{A list returned by \code{cochrane.orcutt}}

\item{...}{Extra arguments passed on to \code{\link{tidy.summary.lm}}}
}
\value{
All tidying methods return a data.frame without rownames, whose
structure depends on the method chosen.

\code{tidy} returns the same information as
\code{\link{tidy.lm}}, though without confidence interval options.

\code{glance} returns the same one-row data frame as
\code{\link{glance.summary.lm}}, along with columns \code{rho}
and \code{number.interaction}.
}
\description{
Tidies a Cochrane Orcutt object, which estimates autocorrelation
and beta coefficients.
This function is not exported and would not typically be called
directly: it is dispatched by \code{\link{tidy.list}} and
\code{\link{glance.list}}.
}
\examples{

reg <- lm(mpg ~ wt + qsec + disp, mtcars)
tidy(reg)

if (require("orcutt", quietly = TRUE)) {
  co <- cochrane.orcutt(reg)
  co
  
  tidy(co)
  glance(co)
}

}
\seealso{
\link{list_tidiers}
}

