% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survival_tidiers.R
\name{coxph_tidiers}
\alias{augment.coxph}
\alias{coxph_tidiers}
\alias{glance.coxph}
\alias{tidy.coxph}
\title{Tidiers for coxph object}
\usage{
\method{tidy}{coxph}(x, exponentiate = FALSE, conf.int = 0.95, ...)

\method{augment}{coxph}(x, data = stats::model.frame(x), newdata,
  type.predict = "lp", type.residuals = "martingale", ...)

\method{glance}{coxph}(x, ...)
}
\arguments{
\item{x}{"coxph" object}

\item{exponentiate}{whether to report the estimate and confidence intervals
on an exponential scale}

\item{conf.int}{confidence level to be used for CI}

\item{...}{Extra arguments, not used}

\item{data}{original data for \code{augment}}

\item{newdata}{new data on which to do predictions}

\item{type.predict}{type of predicted value (see \code{\link{predict.coxph}})}

\item{type.residuals}{type of residuals (see \code{\link{residuals.coxph}})}
}
\value{
\code{tidy} returns a data.frame with one row for each term,
with columns
  \item{estimate}{estimate of slope}
  \item{std.error}{standard error of estimate}
  \item{statistic}{test statistic}
  \item{p.value}{p-value}

\code{augment} returns the original data.frame with additional
columns added:
  \item{.fitted}{predicted values}
  \item{.se.fit}{standard errors }
  \item{.resid}{residuals (not present if \code{newdata} is provided)}

\code{glance} returns a one-row data.frame with statistics
calculated on the cox regression.
}
\description{
Tidy the coefficients of a Cox proportional hazards regression model,
construct predictions, or summarize the entire model into a single row.
}
\details{
When the modeling was performed with \code{na.action = "na.omit"}
(as is the typical default), rows with NA in the initial data are omitted
entirely from the augmented data frame. When the modeling was performed
with \code{na.action = "na.exclude"}, one should provide the original data
as a second argument, at which point the augmented data will contain those
rows (typically with NAs in place of the new columns). If the original data
is not provided to \code{augment} and \code{na.action = "na.exclude"}, a
warning is raised and the incomplete rows are dropped.
}
\examples{

if (require("survival", quietly = TRUE)) {
    cfit <- coxph(Surv(time, status) ~ age + sex, lung)

    tidy(cfit)
    tidy(cfit, exponentiate = TRUE)

    lp <- augment(cfit, lung)
    risks <- augment(cfit, lung, type.predict = "risk")
    expected <- augment(cfit, lung, type.predict = "expected")

    glance(cfit)
    
    # also works on clogit models
    resp <- levels(logan$occupation)
    n <- nrow(logan)
    indx <- rep(1:n, length(resp))
    logan2 <- data.frame(logan[indx,],
                         id = indx,
                         tocc = factor(rep(resp, each=n)))
    logan2$case <- (logan2$occupation == logan2$tocc)

    cl <- clogit(case ~ tocc + tocc:education + strata(id), logan2)
    tidy(cl)
    glance(cl)
    
    library(ggplot2)
    ggplot(lp, aes(age, .fitted, color = sex)) + geom_point()
    ggplot(risks, aes(age, .fitted, color = sex)) + geom_point()
    ggplot(expected, aes(time, .fitted, color = sex)) + geom_point()
}
}
\seealso{
\link{na.action}
}

