% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fixest-tidiers.R
\name{tidy.fixest}
\alias{tidy.fixest}
\title{Tidy a(n) fixest object}
\usage{
\method{tidy}{fixest}(x, conf.int = FALSE, conf.level = 0.95, ...)
}
\arguments{
\item{x}{A \code{fixest} object returned from any of the \code{fixest} estimators}

\item{conf.int}{Logical indicating whether or not to include a confidence
interval in the tidied output. Defaults to \code{FALSE}.}

\item{conf.level}{The confidence level to use for the confidence interval
if \code{conf.int = TRUE}. Must be strictly greater than 0 and less than 1.
Defaults to 0.95, which corresponds to a 95 percent confidence interval.}

\item{...}{Additional arguments passed to \code{summary} and \code{confint}. Important
arguments are \code{se} and \code{cluster}. Other arguments are \code{dof}, \code{exact_dof},
\code{forceCovariance}, and \code{keepBounded}.
See \code{\link[fixest:summary.fixest]{summary.fixest}}.}
}
\description{
Tidy summarizes information about the components of a model.
A model component might be a single term in a regression, a single
hypothesis, a cluster, or a class. Exactly what tidy considers to be a
model component varies across models but is usually self-evident.
If a model has several distinct types of components, you will need to
specify which components to return.
}
\details{
The \code{fixest} package provides a family of functions for estimating
models with arbitrary numbers of fixed-effects, in both an OLS and a GLM
context. The package also supports robust (i.e. White) and clustered
standard error reporting via the generic \code{summary.fixest()} command. In a
similar vein, the \code{tidy()} method for these models allows users to specify
a desired standard error correction either 1) implicitly via the supplied
fixest object, or 2) explicitly as part of the tidy call. See examples
below.

Note that fixest confidence intervals are calculated assuming a normal
distribution -- this assumes infinite degrees of freedom for the CI.
(This assumption is distinct from the degrees of freedom used to calculate
the standard errors. For more on degrees of freedom with clusters and
fixed effects, see \url{https://github.com/lrberge/fixest/issues/6} and
\url{https://github.com/sgaure/lfe/issues/1#issuecomment-530646990})
}
\examples{
\donttest{
library(fixest)
gravity <- feols(log(Euros) ~ log(dist_km) | Origin + Destination + Product + Year, trade)

tidy(gravity)
glance(gravity)
augment(gravity, trade)

## To get robust or clustered SEs, users can either:
tidy(gravity, conf.int = TRUE, cluster = c("Product", "Year"))
tidy(gravity, conf.int = TRUE, se = "threeway")
# 2) Feed tidy() a summary.fixest object that has already accepted these arguments
gravity_summ <- summary(gravity, cluster = c("Product", "Year"))
tidy(gravity_summ, conf.int = TRUE)
# Approach (1) is preferred.

## The other fixest methods all work similarly. For example:
gravity_pois <- feglm(Euros ~ log(dist_km) | Origin + Destination + Product + Year, trade)
tidy(gravity_pois)
glance(gravity_pois)
augment(gravity_pois, trade)
}

}
\seealso{
\code{\link[=tidy]{tidy()}}, \code{\link[fixest:feglm]{fixest::feglm()}}, \code{\link[fixest:femlm]{fixest::fenegbin()}},
\code{\link[fixest:feNmlm]{fixest::feNmlm()}}, \code{\link[fixest:femlm]{fixest::femlm()}}, \code{\link[fixest:feols]{fixest::feols()}}, \code{\link[fixest:feglm]{fixest::fepois()}}

Other fixest tidiers: 
\code{\link{augment.fixest}()}
}
\concept{fixest tidiers}
\value{
A \code{\link[tibble:tibble]{tibble::tibble()}} with columns:
  \item{conf.high}{Upper bound on the confidence interval for the estimate.}
  \item{conf.low}{Lower bound on the confidence interval for the estimate.}
  \item{estimate}{The estimated value of the regression term.}
  \item{p.value}{The two-sided p-value associated with the observed statistic.}
  \item{statistic}{The value of a T-statistic to use in a hypothesis that the regression term is non-zero.}
  \item{std.error}{The standard error of the regression term.}
  \item{term}{The name of the regression term.}

}
