% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boot_generics.R
\name{boot_augment}
\alias{boot_augment}
\title{Bootstrapped dataframe with augmented predictions from each sample.}
\usage{
boot_augment(data, times = 25, strata = NULL, apparent = FALSE, ..f,
  ..., augment.args = list())
}
\arguments{
\item{data}{Dataframe (or tibble) from which variables are to be taken.}

\item{times}{The number of bootstrap samples.}

\item{strata}{A variable that is used to conduct stratified sampling. When
not \code{NULL}, each bootstrap sample is created within the stratification
variable. This could be a single character value or a variable name that
corresponds to a variable that exists in the data frame.}

\item{apparent}{A logical. Should an extra resample be added where the
analysis and holdout subset are the entire data set. This is required for
some estimators used by the \code{summary} function that require the apparent
error rate.}

\item{..f}{A function, or function name as a string.}

\item{...}{Arguments to function.

These dots support \link{tidy-dots} features.}

\item{augment.args}{A list of arguments to be used in the relevant \code{S3} method.}
}
\value{
A \code{\link[tibble:tibble]{tibble::tibble()}} with information about data points.
}
\description{
Bootstrapped dataframe with augmented predictions from each sample.
}
\note{
For available methods, see-
\url{https://indrajeetpatil.github.io/broomExtra/articles/available_methods.html}
}
\section{Methods}{


\Sexpr[stage=render,results=rd]{generics:::methods_rd("augment")}

}

\examples{
set.seed(123)

# example-1: linear model
broomExtra::boot_augment(
  data = mtcars,
  times = 10,
  ..f = stats::lm,
  formula = mpg ~ wt,
  na.action = na.omit
)

# example-2: linear mixed-effects model
library(lme4)

broomExtra::boot_augment(
  data = sleepstudy,
  times = 25,
  ..f = lme4::lmer,
  formula = Reaction ~ Days + (Days | Subject)
)
}
\seealso{
\code{\link{grouped_augment}}, \code{\link{augment}}
}
\author{
\href{https://github.com/IndrajeetPatil}{Indrajeet Patil}
}
