% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/distributions.R
\name{Beta2Dist}
\alias{Beta2Dist}
\alias{dbeta2}
\alias{pbeta2}
\alias{qbeta2}
\alias{rbeta2}
\alias{summary_beta2}
\title{Beta distribution of the second kind}
\usage{
dbeta2(x, c, d, scale, log = FALSE, ...)

pbeta2(q, c, d, scale, ...)

qbeta2(p, c, d, scale, ...)

rbeta2(n, c, d, scale)

summary_beta2(c, d, scale, output = "list", ...)
}
\arguments{
\item{x,q}{vector of quantiles}

\item{c,d}{non-negative shape parameters}

\item{scale}{non-negative scale parameter}

\item{log}{logical; if true, returns the logarithm of the result}

\item{...}{other arguments passed to \code{\link{FDist}}}

\item{p}{vector of probabilities}

\item{n}{number of observations to be simulated}

\item{output}{type of the \code{summary_beta2} output: \code{"list"} to return a list, \code{"pandoc"} to print a table}
}
\value{
\code{dbeta2} gives the density, \code{pbeta2} the distribution function, \code{qbeta2} the quantile function, and \code{rbeta2} generates random observations,
and \code{summary_beta2} returns a summary of the distribution.
}
\description{
Density, distribution function, quantile function and random
generation for the Beta distribution of the second kind with shape parameters
\code{c} and \code{d} and scale parameter \code{scale}.








}
\details{
The Beta distribution of the second kind with shape parameters
\eqn{c>0} and \eqn{d>0} and scale parameter \eqn{k>0} is the distribution of
\eqn{k*(U/(1-U))} where \eqn{U} is a random variable following the Beta distribution
with shape parameters  \eqn{c} and \eqn{d}.
}
\note{
\code{Beta2Dist} is a generic name for the functions documented.
}
\examples{
curve(dbeta2(x, 3, 10, scale=2), from=0, to=3)
u <- rbeta(1e5, 3, 10)
lines(density(2*u/(1-u)), col="blue", lty="dashed")
summary_beta2(3,10,2)
}

