% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/frequentist.R
\name{FrequentistInference}
\alias{FrequentistInference}
\alias{rr_interval_SK}
\alias{rr_interval_binomial}
\alias{rr_intervals}
\title{Frequentist inference about the relative risk}
\usage{
rr_interval_SK(x, y, S, T, conf = 0.95)

rr_interval_binomial(x, y, S, T, conf = 0.95)

rr_intervals(x, y, S, T, conf = 0.95)
}
\arguments{
\item{x,y}{Observed counts}

\item{S,T}{sample sizes}

\item{conf}{confidence level}
}
\value{
\code{rr_interval_binomial} and \code{rr_interval_SK} return
the bounds of the confidence interval
in a vector, \code{rr_intervals} returns a list with the two confidence intervals
}
\description{
Frequentist confidence intervals about the relative risk:
binomial interval (\code{rr_interval_binomial}) and Sahai and Khurshid confidence interval (\code{rr_interval_SK})






}
\details{
The binomial interval (\code{rr_interval_binomial}) is the classical
confidence interval obtained by conditionning on the sum \code{x+y} of
the two counts. The same interval
is implemented in the \code{rateratio.test} package.
The Sahai and Khurshid interval (\code{rr_interval_SK}) is an unconditional confidence interval. See the
reference for more details and a study of its performance.
}
\examples{
x <- 3; y <- 10; S <- 100; T <- 100
rr_intervals(x, y, S, T)
brr_intervals(x, y, S, T)
}
\references{
S. Laurent, C. Legrand: A Bayesian framework for the
ratio of two Poisson rates in the context of vaccine efficacy trials.
ESAIM, Probability & Statistics 16 (2012), 375--398.
}

