% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bruceR_stats_04_regress.R
\name{regress}
\alias{regress}
\title{Regression analysis.}
\usage{
regress(
  formula,
  data,
  family = NULL,
  nsmall = 3,
  robust = FALSE,
  cluster = NULL,
  level2.predictors = "",
  vartypes = NULL,
  test.rand = FALSE
)
}
\arguments{
\item{formula}{Model formula like \code{y ~ x1 + x2} (for \code{lm, glm}) or \code{y ~ x1 + x2 + (1 | group)} (for \code{lmer, glmer}).}

\item{data}{Data frame.}

\item{family}{[optional] The same as in \code{glm} and \code{glmer} (e.g., \code{family=binomial} will fit a logistic model).}

\item{nsmall}{Number of decimal places of output. Default is 3.}

\item{robust}{\strong{[only for \code{lm} and \code{glm}]} \code{FALSE} (default), \code{TRUE}, or an option from \code{"HC0", "HC1", "HC2", "HC3", "HC4", "HC4m", "HC5"}.
It will add a table with heteroskedasticity-robust standard errors (aka. Huber-White standard errors).
For details, see \code{\link[sandwich]{vcovHC}} and \code{\link[jtools]{summ.lm}}.

*** \strong{\code{"HC1"}} is the default of Stata, whereas \strong{\code{"HC3"}} is the default suggested by the \code{sandwich} package.
Here we use \strong{\code{"HC1"}} as the default option.}

\item{cluster}{\strong{[only for \code{lm} and \code{glm}]} Cluster-robust standard errors are computed if cluster is set to the name of the input data's cluster variable or is a vector of clusters.
If you specify \code{cluster}, you may also specify the type of \code{robust}. If you do not specify \code{robust}, \strong{\code{"HC1"}} will be set as the default option.}

\item{level2.predictors}{\strong{[only for \code{lmer}]} [optional] Default is \code{NULL}.
If you have predictors at level 2, besides putting them into the formula in the \code{lmer} function as usual,
you may \strong{also} define here the level-2 grouping/clustering variables and corresponding level-2 predictor variables.

*** Example: \code{level2.predictors="School: W1 + W2; House: 1"},
where \code{School} and \code{House} are two grouping variables,
\code{W1 & W2} are school-level predictors,
and there is no house-level predictor.

*** If there is no level-2 predictor in the formula of \code{lmer}, just leave this parameter blank.}

\item{vartypes}{\strong{[only for \code{lmer}]} Manually setting variable types. Needless in most situations.}

\item{test.rand}{\strong{[only for \code{lmer}]} \code{TRUE} or \code{FALSE} (default).
Test random effects (i.e., variance components) by using the likelihood-ratio test (LRT), which is asymptotically chi-square distributed. For large datasets, it is much time-consuming.
The Wald \emph{Z} test can also be seen in the output of SPSS (the \code{MIXED} syntax).}
}
\value{
No return value.
}
\description{
Regression analysis.
}
\examples{
\donttest{## lm
regress(Temp ~ Month + Day + Wind + Solar.R, data=airquality, robust=TRUE)

## glm
regress(case ~ age + parity + education + spontaneous + induced,
        data=infert, family=binomial, robust="HC1", cluster="stratum")

## lmer
library(lmerTest)
regress(Reaction ~ Days + (Days | Subject), data=sleepstudy)
regress(Preference ~ Sweetness + Gender + Age + Frequency +
          (1 | Consumer), data=carrots)

## glmer
library(lmerTest)
data.glmm=MASS::bacteria
regress(y ~ trt + week + (1 | ID), data=data.glmm, family=binomial)
regress(y ~ trt + week + hilo + (1 | ID), data=data.glmm, family=binomial)
}
}
