% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bsTools2.R
\name{bs_textarea}
\alias{bs_textarea}
\title{Create a HTML textarea tag configured with Bootstrap classes}
\usage{
bs_textarea(
  id,
  value = NULL,
  label = NULL,
  placeholder = NULL,
  text = NULL,
  inline = FALSE,
  required = FALSE,
  div_attr = NULL,
  textarea_attr = c(class = "form-control"),
  label_attr = c(class = "form-label"),
  text_attr = c(class = "form-text")
)
}
\arguments{
\item{id}{A string, the id/name for the textarea, passed to the id and name attributes of the <textarea> tag.}

\item{value}{A string, the value of the textarea, passed to the value attribute of the <textarea> tag.}

\item{label}{A string, the label to use for the textarea, passed to html5::label.}

\item{placeholder}{A string, passed to the placeholder attribute of the <textarea> tag.}

\item{text}{A string, text or HTML to display with the textarea and label tags.}

\item{inline}{TRUE/FALSE, if TRUE, adds a div and classes to display the label and textarea and text in the same line.}

\item{required}{TRUE/FALSE, if TRUE, will add the required attribute to the textarea tag.}

\item{div_attr}{A named list or named vector, names are attribute names and values are attribute values. Passed to the attr parameter of html5::div, wrapping the textarea, label, and text.}

\item{textarea_attr}{A named list or named vector, names are attribute names and values are attribute values. Passed to the attr parameter of html5::textarea.}

\item{label_attr}{A named list or named vector, names are attribute names and values are attribute values. Passed to the attr parameter of html5::label.}

\item{text_attr}{A named list or named vector, names are attribute names and values are attribute values. Passed to the attr parameter of html5::div, which will display the text parameter.}
}
\value{
A string of HTML.
}
\description{
Learn more at \url{https://getbootstrap.com/docs/5.1/forms/overview/}.
}
\examples{
bs_textarea(
id = "example1",
label = "Example Text Area Input"
)
}
