% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expose_model_functions.R
\name{expose_model_functions.bgmfit}
\alias{expose_model_functions.bgmfit}
\alias{expose_model_functions}
\title{Expose user defined Stan function for post-processing of posterior samples}
\usage{
\method{expose_model_functions}{bgmfit}(
  model,
  scode = NULL,
  expose = TRUE,
  select_model = NULL,
  returnobj = TRUE,
  envir = NULL,
  ...
)

expose_model_functions(model, ...)
}
\arguments{
\item{model}{An object of class \code{bgmfit}.}

\item{scode}{An option argument specifying the code with the user-defined
Stan function.}

\item{expose}{A logical (default \code{TRUE}) to indicate whether to expose
functions and add to the global environment.}

\item{select_model}{A string (default \code{NULL}) to indicate the model. For
internal use only.}

\item{returnobj}{A logical (default \code{TRUE}) to indicate whether to
return the model object. When \code{expose=TRUE}, then it is advisable to
set \code{returnobj=TRUE} also.}

\item{envir}{Environment of function evaluation. The default is \code{NULL}
which will set \code{parent.frame()} as default environment. Note that
since most of post processing functions are based on \pkg{brms}, it is
strongly advised to set \code{globalenv()} (or \code{.GlobalEnv}) as
environment. This is particularly true for derivatives such as velocity
curve.}

\item{...}{Additional arguments passed to the
\code{\link[rstan:expose_stan_functions]{rstan::expose_stan_functions()}} function.}
}
\value{
An object of class \code{bgmfit} if \code{returnobj=TRUE}, otherwise
invisible \code{NULL}.
}
\description{
The \strong{expose_model_functions()} is a wrapper around
the \code{\link[rstan:expose_stan_functions]{rstan::expose_stan_functions()}} function which is used to expose the
use defined \code{Stan} functions. These exposed functions are required
during the post-processing. See \code{\link[rstan:expose_stan_functions]{rstan::expose_stan_functions()}} for
details.
}
\examples{

# Fit Bayesian SITAR model 

# To avoid fitting the model which takes time, the model  
# fit has already been saved as 'berkeley_mfit.rda' file.
# See examples section of the main function for details on the model fit.

model <- berkeley_mfit

\donttest{
expose_model_functions(model)
}

}
\seealso{
\code{\link[rstan:expose_stan_functions]{rstan::expose_stan_functions()}}
}
\author{
Satpal Sandhu  \email{satpal.sandhu@bristol.ac.uk}
}
