% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bs-theme-preview.R
\name{run_with_themer}
\alias{run_with_themer}
\alias{bs_themer}
\title{Theme customization UI}
\usage{
run_with_themer(appDir = getwd(), ..., gfonts = TRUE, gfonts_update = FALSE)

bs_themer(gfonts = TRUE, gfonts_update = FALSE)
}
\arguments{
\item{appDir}{The application to run. This can be a file or directory path,
or a \code{\link[shiny:shinyApp]{shiny::shinyApp()}} object. See \code{\link[shiny:runApp]{shiny::runApp()}} for details.}

\item{...}{Additional parameters to pass through to \code{\link[shiny:runApp]{shiny::runApp()}}.}

\item{gfonts}{whether or not to detect Google Fonts and wrap them in
\code{\link[=font_google]{font_google()}} (so that their font files are automatically imported).}

\item{gfonts_update}{whether or not to update the internal database of
Google Fonts.}
}
\value{
nothing. These functions are called for their side-effects.
}
\description{
A 'real-time' theme customization UI that you can use to easily make common
tweaks to Bootstrap variables and immediately see how they would affect your
app's appearance. There are two ways you can launch the theming UI. For most
Shiny apps, just use \code{run_with_themer()} in place of \code{\link[shiny:runApp]{shiny::runApp()}}; they
should take the same arguments and work the same way. Alternatively, you can
call the \code{bs_themer()} function from inside your server function (or in an R
Markdown app that is using \code{runtime: shiny}, you can call this from any code
chunk). Note that this function is only intended to be used for development!
}
\details{
To help you utilize the changes you see in the preview, this utility prints
\code{\link[=bs_theme]{bs_theme()}} code to the R console.
}
\section{Limitations}{

\itemize{
\item Doesn't work with Bootstrap 3.
\item Doesn't work with IE11.
\item Only works inside Shiny apps and \code{runtime: shiny} R Markdown documents.
\itemize{
\item Can't be used with static R Markdown documents.
\item Can be used to some extent with \code{runtime: shiny_prerendered}, but only UI
rendered through a \code{context="server"} may update in real-time.
}
\item Doesn't work with '3rd party' custom widgets that don't make use of
\code{\link[=bs_dependency_defer]{bs_dependency_defer()}} or \code{\link[=bs_current_theme]{bs_current_theme()}}.
}
}

\examples{
library(shiny)

# Initialize Bootstrap 4 with Bootstrap 3 compatibility shim
theme <- bs_theme(version = 4, bg = "black", fg = "white")

ui <- fluidPage(
  theme = theme,
  h1("Heading 1"),
  h2("Heading 2"),
  p(
    "Paragraph text;",
    tags$a(href = "https://www.rstudio.com", "a link")
  ),
  p(
    actionButton("cancel", "Cancel"),
    actionButton("continue", "Continue", class = "btn-primary")
  ),
  tabsetPanel(
    tabPanel("First tab",
      "The contents of the first tab"
    ),
    tabPanel("Second tab",
      "The contents of the second tab"
    )
  )
)

if (interactive()) {
  run_with_themer(shinyApp(ui, function(input, output) {}))
}

}
