% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/approx.R
\name{gaussian_approx}
\alias{gaussian_approx}
\alias{gaussian_approx.nongaussian}
\alias{gaussian_approx.ssm_nlg}
\title{Gaussian Approximation of Non-Gaussian/Non-linear State Space Model}
\usage{
gaussian_approx(model, max_iter, conv_tol, ...)

\method{gaussian_approx}{nongaussian}(model, max_iter = 100, conv_tol = 1e-08, ...)

\method{gaussian_approx}{ssm_nlg}(model, max_iter = 100, conv_tol = 1e-08, iekf_iter = 0, ...)
}
\arguments{
\item{model}{Model to be approximated.}

\item{max_iter}{Maximum number of iterations.}

\item{conv_tol}{Tolerance parameter.}

\item{...}{Ignored.}

\item{iekf_iter}{For non-linear models, number of iterations in iterated EKF (defaults to 0).}
}
\description{
Returns the approximating Gaussian model. This function is rarely needed itself, 
and is mainly available for testing and debugging purposes.
}
\examples{
data("poisson_series")
model <- bsm_ng(y = poisson_series, sd_slope = 0.01, sd_level = 0.1,
  distribution = "poisson")
out <- gaussian_approx(model)
}
