% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{ar1_ng}
\alias{ar1_ng}
\title{Non-Gaussian model with AR(1) latent process}
\usage{
ar1_ng(y, rho, sigma, mu, distribution, phi, u = 1, beta, xreg = NULL)
}
\arguments{
\item{y}{Vector or a \code{\link{ts}} object of observations.}

\item{rho}{prior for autoregressive coefficient.}

\item{sigma}{Prior for the standard deviation of noise of the AR-process.}

\item{mu}{A fixed value or a prior for the stationary mean of the latent 
AR(1) process. Parameter is omitted if this is set to 0.}

\item{distribution}{Distribution of the observed time series. Possible 
choices are \code{"poisson"}, \code{"binomial"}, \code{"gamma"}, and 
\code{"negative binomial"}.}

\item{phi}{Additional parameter relating to the non-Gaussian distribution.
For negative binomial distribution this is the dispersion term, for gamma 
distribution this is the shape parameter, and for other distributions this 
is ignored.}

\item{u}{Constant parameter vector for non-Gaussian models. For Poisson, 
gamma, and negative binomial distribution, this corresponds to the offset 
term. For binomial, this is the number of trials.}

\item{beta}{Prior for the regression coefficients.}

\item{xreg}{Matrix containing covariates.}
}
\value{
Object of class \code{ar1_ng}.
}
\description{
Constructs a simple non-Gaussian model where the state dynamics follow an 
AR(1) process.
}
\examples{
model <- ar1_ng(discoveries, rho = uniform(0.5,-1,1), 
  sigma = halfnormal(0.1, 1), mu = normal(0, 0, 1), 
  distribution = "poisson")
out <- run_mcmc(model, iter = 1e4, mcmc_type = "approx",
  output_type = "summary")
  
ts.plot(cbind(discoveries, exp(out$alphahat)), col = 1:2)

}
