% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/priors.R
\name{uniform}
\alias{uniform}
\alias{halfnormal}
\alias{normal}
\alias{tnormal}
\alias{gamma}
\title{Prior objects for bssm models}
\usage{
uniform(init, min, max)

halfnormal(init, sd)

normal(init, mean, sd)

tnormal(init, mean, sd, min = -Inf, max = Inf)

gamma(init, shape, rate)
}
\arguments{
\item{init}{Initial value for the parameter, used in initializing the model 
components and as a starting values in MCMC.}

\item{min}{Lower bound of the uniform and truncated normal prior.}

\item{max}{Upper bound of the uniform and truncated normal prior.}

\item{sd}{Standard deviation of the (underlying i.e. non-truncated) 
Normal distribution.}

\item{mean}{Mean of the Normal prior.}

\item{shape}{Shape parameter of the Gamma prior.}

\item{rate}{Rate parameter of the Gamma prior.}
}
\value{
object of class \code{bssm_prior}.
}
\description{
These simple objects of class \code{bssm_prior} are used to construct a 
prior distributions for the 
MCMC runs of \code{bssm} package. Currently supported priors are uniform 
(\code{uniform()}), half-normal (\code{halfnormal()}), 
normal (\code{normal()}), gamma (\code{gamma}), and 
truncated normal distribution  (\code{tnormal()}). All parameters are 
vectorized so for regression coefficient vector beta you can define prior 
for example as \code{normal(0, 0, c(10, 20))}.
}
\examples{
# create uniform prior on [-1, 1] for one parameter with initial value 0.2:
uniform(0.2, -1, 1)
# two normal priors at once i.e. for coefficients beta:
normal(init = c(0.1, 2), mean = 0, sd = c(1, 2))
}
