% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_draws.R
\name{as_draws_df.mcmc_output}
\alias{as_draws_df.mcmc_output}
\alias{as_draws.mcmc_output}
\title{Convert \code{run_mcmc} output to \code{draws_df} format}
\usage{
as_draws_df.mcmc_output(x)

as_draws.mcmc_output(x)
}
\arguments{
\item{x}{An object of class \code{mcmc_output}}
}
\value{
A \code{draws_df} object.
}
\description{
Converts MCMC output from \code{run_mcmc} call to a 
\code{draws_df} format of the \code{posterior} package. This enables the use 
of diagnostics and plotting methods of \code{posterior} and \code{bayesplot} 
packages. Note though that if \code{run_mcmc} used IS-MCMC 
method, the resulting \code{weight} column of the output is 
ignored by the aforementioned packages, i.e. the results correspond to 
approximate MCMC.
}
\examples{

model <- bsm_lg(Nile, 
  sd_y = tnormal(init = 100, mean = 100, sd = 100, min = 0),
  sd_level = tnormal(init = 50, mean = 50, sd = 100, min = 0),
  a1 = 1000, P1 = 500^2)

fit1 <- run_mcmc(model, iter = 2000)
library("posterior")
draws <- as_draws(fit1)
head(draws, 4)
ess_bulk(draws$sd_y)
summary(fit1, return_se = TRUE)

# More chains:
model$theta[] <- c(50, 150) # change initial value
fit2 <- run_mcmc(model, iter = 2000)
model$theta[] <- c(150, 50) # change initial value
fit3 <- run_mcmc(model, iter = 2000)

draws <- bind_draws(as_draws(fit1),
  as_draws(fit2), as_draws(fit3), along = "chain")
# it is actually enough to transform first mcmc_output to draws object, 
# rest are transformed automatically inside bind_draws
rhat(draws$sd_y)
ess_bulk(draws$sd_y)
ess_tail(draws$sd_y)

}
