% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/asymptotic_var.R
\name{estimate_ess}
\alias{estimate_ess}
\title{Effective Sample Size for IS-type Estimators}
\usage{
estimate_ess(x, w, method = "sokal")
}
\arguments{
\item{x}{A numeric vector of samples.}

\item{w}{A numeric vector of weights. If missing, set to 1 (i.e. no
weighting is assumed).}

\item{method}{Method for computing the ESS. Default is \code{"sokal"}, other
option are \code{"geyer"} (see also \code{asymptotic_var}).}
}
\value{
A single numeric value of effective sample size estimate.
}
\description{
Computes the effective sample size (ESS) based on weighted posterior
samples.
}
\details{
The asymptotic variance MCMCSE^2 is based on Corollary 1 of
Vihola et al. (2020) which is used to compute an estimate for the ESS
using the identity ESS(x) = var(x) / MCMCSE^2 where var(x) is the
posterior variance of x assuming independent samples.
}
\examples{
set.seed(1)
n <- 1e4 
x <- numeric(n)
phi <- 0.7
for(t in 2:n) x[t] <- phi * x[t-1] + rnorm(1)
w <- rexp(n, 0.5 * exp(0.001 * x^2))
# different methods:
estimate_ess(x, w, method = "sokal")
estimate_ess(x, w, method = "geyer")

}
\references{
Vihola, M, Helske, J, Franks, J. (2020). Importance sampling type estimators
based on approximate marginal Markov chain Monte Carlo.
Scand J Statist. 1-38. https://doi.org/10.1111/sjos.12492

Sokal A. (1997). Monte Carlo Methods in Statistical Mechanics: Foundations
and New Algorithms.
In: DeWitt-Morette C, Cartier P, Folacci A (eds) Functional Integration.
NATO ASI Series (Series B: Physics), vol 361. Springer, Boston, MA.
https://doi.org/10.1007/978-1-4899-0319-8_6

Gelman, A, Carlin J B, Stern H S, Dunson, D B, Vehtari A, Rubin D B. (2013).
Bayesian Data Analysis, Third Edition. Chapman and Hall/CRC.
}
