% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/specify_bsvar.R
\name{specify_starting_values_bsvar}
\alias{specify_starting_values_bsvar}
\title{R6 Class Representing StartingValuesBSVAR}
\description{
The class StartingValuesBSVAR presents starting values for the homoskedastic bsvar model.
}
\examples{
# starting values for a homoskedastic bsvar for a 3-variable system
sv = specify_starting_values_bsvar$new(N = 3, p = 1)


## ------------------------------------------------
## Method `specify_starting_values_bsvar$new`
## ------------------------------------------------

# starting values for a homoskedastic bsvar with 4 lags for a 3-variable system
sv = specify_starting_values_bsvar$new(N = 3, p = 4)


## ------------------------------------------------
## Method `specify_starting_values_bsvar$get_starting_values`
## ------------------------------------------------

# starting values for a homoskedastic bsvar with 1 lag for a 3-variable system
sv = specify_starting_values_bsvar$new(N = 3, p = 1)
sv$get_starting_values()   # show starting values as list


## ------------------------------------------------
## Method `specify_starting_values_bsvar$set_starting_values`
## ------------------------------------------------

# starting values for a homoskedastic bsvar with 1 lag for a 3-variable system
sv = specify_starting_values_bsvar$new(N = 3, p = 1)

# Modify the starting values by:
sv_list = sv$get_starting_values()   # getting them as list
sv_list$A <- matrix(rnorm(12), 3, 4) # modifying the entry
sv$set_starting_values(sv_list)      # providing to the class object

}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{A}}{an \code{NxK} matrix of starting values for the parameter \eqn{A}.}

\item{\code{B}}{an \code{NxN} matrix of starting values for the parameter \eqn{B}.}

\item{\code{hyper}}{a \code{(2*N+1)x2} matrix of starting values for the shrinkage hyper-parameters of the 
hierarchical prior distribution.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-StartingValuesBSVAR-new}{\code{specify_starting_values_bsvar$new()}}
\item \href{#method-StartingValuesBSVAR-get_starting_values}{\code{specify_starting_values_bsvar$get_starting_values()}}
\item \href{#method-StartingValuesBSVAR-set_starting_values}{\code{specify_starting_values_bsvar$set_starting_values()}}
\item \href{#method-StartingValuesBSVAR-clone}{\code{specify_starting_values_bsvar$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-StartingValuesBSVAR-new"></a>}}
\if{latex}{\out{\hypertarget{method-StartingValuesBSVAR-new}{}}}
\subsection{Method \code{new()}}{
Create new starting values StartingValuesBSVAR.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{specify_starting_values_bsvar$new(N, p, d = 0)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{N}}{a positive integer - the number of dependent variables in the model.}

\item{\code{p}}{a positive integer - the autoregressive lag order of the SVAR model.}

\item{\code{d}}{a positive integer - the number of \code{exogenous} variables in the model.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Starting values StartingValuesBSVAR.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# starting values for a homoskedastic bsvar with 4 lags for a 3-variable system
sv = specify_starting_values_bsvar$new(N = 3, p = 4)

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-StartingValuesBSVAR-get_starting_values"></a>}}
\if{latex}{\out{\hypertarget{method-StartingValuesBSVAR-get_starting_values}{}}}
\subsection{Method \code{get_starting_values()}}{
Returns the elements of the starting values StartingValuesBSVAR as a \code{list}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{specify_starting_values_bsvar$get_starting_values()}\if{html}{\out{</div>}}
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# starting values for a homoskedastic bsvar with 1 lag for a 3-variable system
sv = specify_starting_values_bsvar$new(N = 3, p = 1)
sv$get_starting_values()   # show starting values as list

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-StartingValuesBSVAR-set_starting_values"></a>}}
\if{latex}{\out{\hypertarget{method-StartingValuesBSVAR-set_starting_values}{}}}
\subsection{Method \code{set_starting_values()}}{
Returns the elements of the starting values StartingValuesBSVAR as a \code{list}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{specify_starting_values_bsvar$set_starting_values(last_draw)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{last_draw}}{a list containing the last draw of elements \code{B} - an \code{NxN} matrix, 
\code{A} - an \code{NxK} matrix, and \code{hyper} - a vector of 5 positive real numbers.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An object of class StartingValuesBSVAR including the last draw of the current MCMC 
as the starting value to be passed to the continuation of the MCMC estimation using \code{estimate()}.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# starting values for a homoskedastic bsvar with 1 lag for a 3-variable system
sv = specify_starting_values_bsvar$new(N = 3, p = 1)

# Modify the starting values by:
sv_list = sv$get_starting_values()   # getting them as list
sv_list$A <- matrix(rnorm(12), 3, 4) # modifying the entry
sv$set_starting_values(sv_list)      # providing to the class object

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-StartingValuesBSVAR-clone"></a>}}
\if{latex}{\out{\hypertarget{method-StartingValuesBSVAR-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{specify_starting_values_bsvar$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
