% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary.PosteriorBSVART}
\alias{summary.PosteriorBSVART}
\title{Provides posterior summary of Structural VAR with t-distributed shocks estimation}
\usage{
\method{summary}{PosteriorBSVART}(object, ...)
}
\arguments{
\item{object}{an object of class PosteriorBSVART obtained using the
\code{estimate()} function applied to homoskedastic Bayesian Structural VAR
model specification set by function \code{specify_bsvar$new()} containing 
draws from the  posterior distribution of the parameters.}

\item{...}{additional arguments affecting the summary produced.}
}
\value{
A list reporting the posterior mean, standard deviations, as well as 5 and 95 
percentiles of the parameters: the structural matrix \eqn{B}, autoregressive 
parameters \eqn{A}, hyper-parameters, and Student-t degrees-of-freedom 
parameter \eqn{\nu}.
}
\description{
Provides posterior mean, standard deviations, as well as 5 and 95 
percentiles of the parameters: the structural matrix \eqn{B}, autoregressive 
parameters \eqn{A}, hyper-parameters, and Student-t degrees-of-freedom 
parameter \eqn{\nu}.
}
\examples{
# upload data
data(us_fiscal_lsuw)

# specify the model and set seed
set.seed(123)
specification  = specify_bsvar_t$new(us_fiscal_lsuw)

# run the burn-in
burn_in        = estimate(specification, 10)

# estimate the model
posterior      = estimate(burn_in, 20)
summary(posterior)

# workflow with the pipe |>
############################################################
set.seed(123)
us_fiscal_lsuw |>
  specify_bsvar_t$new() |>
  estimate(S = 10) |> 
  estimate(S = 20) |> 
  summary()

}
\seealso{
\code{\link{estimate}}, \code{\link{specify_bsvar_t}}
}
\author{
Tomasz Woźniak \email{wozniak.tom@pm.me}
}
