% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interpretation.R
\name{marginalplot}
\alias{marginalplot}
\title{Plot marginal effects for two-way interactions in (T)ERGMs}
\usage{
marginalplot(
  model,
  var1,
  var2,
  inter,
  ci = 0.95,
  rug = FALSE,
  point = FALSE,
  structzeromat = NULL,
  zeroline = TRUE,
  color = "black",
  xlab = NULL,
  ylab = NULL
)
}
\arguments{
\item{model}{An \code{ergm} object as generated by the \pkg{ergm} package.
Note that marginal effects plots cannot be created for \code{btergm}
objects because the variance-covariance matrix is not valid. However, it
should be possible to apply the \code{marginalplot} function to
MCMC-MLE-estimated TERGMs because the \code{ergm} object is stored in the
\code{ergm} slot of an \code{mtergm} object. To do this, supply the
\code{ergm} object instead of the \code{mtergm} object (e.g.,
\code{marginalplot(mtergmobject@ergm)}).}

\item{var1}{Name of the first main variable. This is the focal variable.}

\item{var2}{Name of the second main variable. This is the conditioning
variable.}

\item{inter}{Name of the interaction effect.}

\item{ci}{Significance level.}

\item{rug}{Display the distribution of the conditioning variable at the
bottom of the plot?}

\item{point}{Display error bars for the levels of the conditioning variable
(instead of a continuous curve)?}

\item{structzeromat}{An optional matrix object which indicates dyads that
should be deleted prior to the calculation of the confidence interval for
the marginal effect curve. This is useful when such a matrix was used to
indicate structural zeros during estimation. In this event, the dyads
characterized by structural zeros are not allowed to be tied, therefore
they should be removed from the set of dyads used for the calculation of
marginal effects. The matrix should contain ones for structural zeros and
zeros for entries that should be used.}

\item{zeroline}{Draw a horizontal line to indicate zero for the first main
variable?}

\item{color}{Color of the curve, confidence interval, and distribution.}

\item{xlab}{Axis label for the second (conditioning) variable.}

\item{ylab}{Axis label for the first (focal) variable.}
}
\description{
Plot marginal effects for two-way interactions in (T)ERGMs.
}
\details{
The \code{marginalplot} function creates marginal effects plots for ERGMs
with interaction effects. The user has to supply the \code{ergm} object and
the coefficient names of the first main variable, the second main variable,
and the interaction term as stored in the coefficients vector inside the
\code{ergm} object. It is possible to draw continuous curves or discrete
error bars depending on the nature of the data (using the \code{point}
argument). The distribution of the second (conditioning) variable can be
plotted at the bottom of the viewport using the \code{rug} argument.

The resulting marginal effects plot is a \code{ggplot2} plot. This means it
can be extended by plotting additional elements and using themes.
}
\examples{
\dontrun{
# data preparation
data("florentine")
n <- network.size(flobusiness)
wealth <- get.vertex.attribute(flobusiness, "wealth")
priorates <- get.vertex.attribute(flobusiness, "priorates")
wealth.icov <- matrix(rep(wealth, n), ncol = n, byrow = TRUE)
priorates.icov <- matrix(rep(priorates, n), ncol = n, byrow = TRUE)
interac <- wealth.icov * priorates.icov

# estimate model with interaction effect
model <- ergm(flobusiness ~ edges + esp(1) + edgecov(wealth.icov) 
                + edgecov(priorates.icov) + edgecov(interac))

# plot the interaction (note the additional optional ggplot2 elements)
marginalplot(model, var1 = "edgecov.wealth.icov", 
             var2 = "edgecov.priorates.icov", inter = "edgecov.interac", 
             color = "darkred", rug = TRUE, point = FALSE,
             xlab = "Priorates", ylab = "Wealth") +
  ggplot2::theme_bw() +
  ggplot2::ggtitle("Interaction effect")
}

}
\seealso{
Other interpretation: 
\code{\link{edgeprob}()},
\code{\link{interpret}()}
}
\concept{interpretation}
