% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_spss_data.R
\name{read_spss_data}
\alias{read_spss_data}
\title{Read SPSS data File}
\usage{
read_spss_data(file, label = FALSE)
}
\arguments{
\item{file}{The path to the SPSS data file.}

\item{label}{Logical indicating whether to use variable labels as column names (default is FALSE).}
}
\value{
A tibble containing the data from the SPSS file.
}
\description{
\code{read_spss_data()} is designed to seamlessly import data from an SPSS data (\code{.sav} or  \code{.zsav}) files. It converts labelled variables into factors, a crucial step that enhances the ease of data manipulation and analysis within the R programming environment.
}
\examples{
# Read an SPSS data file without converting variable labels as column names

file_path <- system.file("extdata", "Wages.sav", package = "bulkreadr")

data <- read_spss_data(file = file_path)

data

# Read an SPSS data file and convert variable labels as column names

data <- read_spss_data(file = file_path, label = TRUE)

data

}
\seealso{
\code{\link[=read_stata_data]{read_stata_data()}} which reads Stata data file and converts labelled variables into factors.
}
