% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/domregion.R
\name{domregion}
\alias{domregion}
\title{Dominated Region}
\usage{
domregion(zstar, t0, t1, binwidth)
}
\arguments{
\item{zstar}{a numeric value for the the bunching point.}

\item{t0}{numeric value setting the marginal (average) tax rate below zstar in a kink (notch) setting.}

\item{t1}{numeric value setting the marginal (average) tax rate above zstar in a kink (notch) setting.}

\item{binwidth}{a numeric value for the width of each bin.}
}
\value{
\code{domregion} returns a list with the following objects related to the dominated region (in notch settings only):
\item{zD}{The level of z that demarcates the upper bound of the dominated region.}
\item{zD_bin}{The value of the bin which zD falls in.}
}
\description{
Estimate z (the value of z_vector) that demarcates the upper bound of the dominated region (in notch settings only).
}
\examples{
domregion(zstar = 10000, t0 = 0, t1 = 0.2, binwidth = 50)
}
\seealso{
\code{\link{bunchit}}
}
