% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recipe.R
\name{axe-recipe}
\alias{axe-recipe}
\alias{axe_env.recipe}
\alias{axe_env.step}
\alias{axe_env.step_arrange}
\alias{axe_env.step_filter}
\alias{axe_env.step_mutate}
\alias{axe_env.step_slice}
\alias{axe_env.step_impute_bag}
\alias{axe_env.step_bagimpute}
\alias{axe_env.step_impute_knn}
\alias{axe_env.step_knnimpute}
\alias{axe_env.step_geodist}
\alias{axe_env.step_interact}
\alias{axe_env.step_ratio}
\alias{axe_env.quosure}
\alias{axe_fitted.recipe}
\title{Axing a recipe object.}
\usage{
\method{axe_env}{recipe}(x, verbose = FALSE, ...)

\method{axe_env}{step}(x, ...)

\method{axe_env}{step_arrange}(x, ...)

\method{axe_env}{step_filter}(x, ...)

\method{axe_env}{step_mutate}(x, ...)

\method{axe_env}{step_slice}(x, ...)

\method{axe_env}{step_impute_bag}(x, ...)

\method{axe_env}{step_bagimpute}(x, ...)

\method{axe_env}{step_impute_knn}(x, ...)

\method{axe_env}{step_knnimpute}(x, ...)

\method{axe_env}{step_geodist}(x, ...)

\method{axe_env}{step_interact}(x, ...)

\method{axe_env}{step_ratio}(x, ...)

\method{axe_env}{quosure}(x, ...)

\method{axe_fitted}{recipe}(x, verbose = FALSE, ...)
}
\arguments{
\item{x}{A model object.}

\item{verbose}{Print information each time an axe method is executed.
Notes how much memory is released and what functions are
disabled. Default is \code{FALSE}.}

\item{...}{Any additional arguments related to axing.}
}
\value{
Axed recipe object.
}
\description{
recipe objects are created from the \pkg{recipes} package, which is
leveraged for its set of data pre-processing tools. These recipes work
by sequentially defining each pre-processing step. The implementation
of each step, however, results its own class so we bundle all the axe
methods related to recipe objects in general here. Note that the
butchered class is only added to the recipe as a whole, and not to each
pre-processing step.
}
\examples{
suppressPackageStartupMessages(library(recipes))
library(modeldata)

data(biomass)

biomass_tr <- biomass[biomass$dataset == "Training",]
rec <- recipe(HHV ~ carbon + hydrogen + oxygen + nitrogen + sulfur,
              data = biomass_tr) \%>\%
  step_center(all_predictors()) \%>\%
  step_scale(all_predictors()) \%>\%
  step_spatialsign(all_predictors())

out <- butcher(rec, verbose = TRUE)

# Another recipe object
wrapped_recipes <- function() {
  some_junk_in_environment <- runif(1e6)
  return(
    recipe(mpg ~ cyl, data = mtcars) \%>\%
      step_center(all_predictors()) \%>\%
      step_scale(all_predictors()) \%>\%
      prep()
  )
}

# Remove junk in environment
cleaned1 <- axe_env(wrapped_recipes(), verbose = TRUE)
# Replace prepared training data with zero-row slice
cleaned2 <- axe_fitted(wrapped_recipes(), verbose = TRUE)

# Check size
lobstr::obj_size(cleaned1)
lobstr::obj_size(cleaned2)

}
