% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coxph.R
\name{axe-coxph}
\alias{axe-coxph}
\alias{axe_env.coxph}
\alias{axe_data.coxph}
\title{Axing a coxph.}
\usage{
\method{axe_env}{coxph}(x, verbose = FALSE, ...)

\method{axe_data}{coxph}(x, verbose = FALSE, ...)
}
\arguments{
\item{x}{A model object.}

\item{verbose}{Print information each time an axe method is executed.
Notes how much memory is released and what functions are
disabled. Default is \code{FALSE}.}

\item{...}{Any additional arguments related to axing.}
}
\value{
Axed coxph object.
}
\description{
Axing a coxph.
}
\details{
The \code{\link[survival:coxph]{survival::coxph()}} model is unique in how it uses environments in
its components, and butchering such an object can behave in surprising ways
in any environment other than the
\href{https://adv-r.hadley.nz/environments.html#important-environments}{global environment}
(such as when wrapped in a function). We do not recommend that you use
\code{butcher()} with a \code{coxph} object anywhere other than the global environment.

Do this:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{my_coxph_func <- function(df) \{
    coxph(Surv(time, status) ~ x + strata(covar), df)
\}
## in global environment only:
butcher(my_coxph_func(df))
}\if{html}{\out{</div>}}

Do \emph{not} do this:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{my_coxph_func <- function(df) \{
    res <- coxph(Surv(time, status) ~ x + strata(covar), df)
    ## no:
    butcher(res)
\}

## will not work correctly:
my_coxph_func(df)
}\if{html}{\out{</div>}}
}
\examples{
\dontshow{if (rlang::is_installed("survival")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(survival)

example_data <-
  tibble::tibble(
    time = rpois(1000, 2) + 1,
    status = rbinom(1000, 1, .5),
    x = rpois(1000, .5),
    covar = rbinom(1000, 1, .5)
  )

example_data

make_big_model <- function() {
  boop <- runif(1e6)
  coxph(Surv(time, status) ~ x + strata(covar), example_data)
}

res <- make_big_model()

weigh(res)
weigh(butcher(res))
\dontshow{\}) # examplesIf}
}
