% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate-process.R
\name{sim_gig}
\alias{sim_gig}
\title{Generate Generalized Inverse Gaussian Distribution}
\usage{
sim_gig(num_sim, lambda, psi, chi)
}
\arguments{
\item{num_sim}{Number to generate}

\item{lambda}{Index of modified Bessel function of third kind.}

\item{psi}{Second parameter of GIG. Should be positive.}

\item{chi}{Third parameter of GIG. Should be positive.}
}
\description{
This function samples \eqn{GIG(\lambda, \psi, \chi)} random variates.
}
\details{
The density of \eqn{GIG(\lambda, \psi, \chi)} considered here is as follows.
\deqn{f(x) = \frac{(\psi / \chi)^(\lambda / 2)}{2 K_{\lambda}(\sqrt{\psi \chi})} x^{\lambda - 1} \exp(-\frac{1}{2} (\frac{\chi}{x} + \psi x))}
where \eqn{x > 0}.
}
\references{
Hörmann, W., Leydold, J. \emph{Generating generalized inverse Gaussian random variates}. Stat Comput 24, 547-557 (2014).

Leydold, J, Hörmann, W.. \emph{GIGrvg: Random Variate Generator for the GIG Distribution}. R package version 0.8 (2023).
}
