% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/child_reference_ei.R
\name{child_reference_EI}
\alias{child_reference_EI}
\title{Energy Intake Matrix}
\usage{
child_reference_EI(age, sex, FM, FFM, days, dt = 1)
}
\arguments{
\item{age}{(vector) Age of individual (yrs)}

\item{sex}{(vector) Sex either \code{"female"} or \code{"male"}}

\item{FM}{(vector) Fat Mass at Baseline}

\item{FFM}{(vector) Fat Free Mass at Baseline

\strong{ Optional }}

\item{days}{(numeric) Days to run the model.}

\item{dt}{(double) Step for RK4}
}
\description{
Estimates weight given age, sex, fat mass, and fat free mass,
}
\examples{
#One child
child_reference_EI(6, "male", 2, 4, 10)

#Several children
child_reference_EI(sample(6:12, 10, replace = TRUE), 
                   sample(c("male","female"), 10, replace = TRUE), 
                   sample(2:10, 10, replace = TRUE), 
                   sample(2:10, 10, replace = TRUE),
                   365)

}
\references{
Hall, K. D., Butte, N. F., Swinburn, B. A., & Chow, C. C. (2013). 
\emph{Dynamics of childhood growth and obesity: development and validation of a 
quantitative mathematical model}. The Lancet Diabetes & Endocrinology, 1(2), 97-105.

Haschke, F. (1989). \emph{Body Composition During Adolescence.} 
Body Composition Measurements in Infants and Children.
Ross Laboratories Columbus, OH, 76–83.

Fomon, Samuel J, Ferdinand Haschke, Ekhard E Ziegler, and Steven E Nelson. 1982. 
\emph{Body Composition of Reference Children from Birth to Age 10 Years.}
The American Journal of Clinical Nutrition 35 (5). Am Soc Nutrition: 1169–75.
 
Ellis, Kenneth J, Roman J Shypailo, Steven A Abrams, and William W Wong. 2000. 
\emph{The Reference Child and Adolescent Models of Body Composition: A Contemporary Comparison.} 
Annals of the New York Academy of Sciences 904 (1). Wiley Online Library: 374–82.
 
Deurenberg, Paul, Jan A Weststrate, and Jaap C Seidell. 1991. 
\emph{Body Mass Index as a Measure of Body Fatness: Age-and Sex-Specific Prediction Formulas.} 
British Journal of Nutrition 65 (2). Cambridge University Press: 105–14.

Katan, Martijn B, Janne C De Ruyter, Lothar DJ Kuijper, Carson C Chow, Kevin D Hall, and Margreet R Olthof. 2016.
\emph{Impact of Masked Replacement of Sugar-Sweetened with Sugar-Free Beverages on Body Weight Increases with Initial Bmi:
Secondary Analysis of Data from an 18 Month Double–Blind Trial in Children.} 
PloS One 11 (7). Public Library of Science: e0159771.
}
\seealso{
\code{\link{model_plot}} for plotting the results and 
\code{\link{model_mean}} for aggregate data estimation.
}
\author{
Rodrigo Zepeda-Tello \email{rzepeda17@gmail.com}

Dalia Camacho-García-Formentí \email{daliaf172@gmail.com}
}
\keyword{internal}
