% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/base.R
\name{pairwise.bzinb}
\alias{pairwise.bzinb}
\title{Pairwise underlying correlation based on bivariate zero-inflated negative binomial (BZINB) model}
\usage{
pairwise.bzinb(data, nonzero.prop = TRUE, fullParam = FALSE,
  showFlag = FALSE, nsample = NULL, ...)
}
\arguments{
\item{data}{a matrix with nonnegative integers. rows represent the feature (or gene), and
columns represent the sample. If not integers, rounded to the nearest integers.}

\item{nonzero.prop}{logical. If \code{TRUE}, proportion of nonzero for each of the pair is returned.}

\item{fullParam}{logical. If \code{TRUE}, estimates of all parameters are returned.}

\item{showFlag}{logical. If \code{TRUE}, for each pair, the estimates are printed out.}

\item{nsample}{positive integer. If provided, \code{nsample} random pairs will only be considered for 
correlation. A non-integer will be rounded to the nearest integer.}

\item{...}{Other arguments passed on to \code{bzinb} function.}
}
\value{
a table of pairwise underlying correlation (\eqn{\rho}) and related statistics.
 \itemize{
   \item \code{1} row number of the first vector of the pair
   \item \code{2} row number of the second vector of the pair
   \item \code{pair} row numbers of the pair
   \item \code{rho} underlying correlation estimate
   \item \code{se.rho} standard error of the underlying correlation estimate
   \item \code{nonzero.1, nonzero.2} non-zero proportion of the first and the second vector. 
         Returned if \code{nonzero.prop} is \code{TRUE}.
   \item \code{nonzero.min} pairwise minimum of non-zero proportions
         Returned if \code{nonzero.prop} is \code{TRUE}.
   \item \code{a0, a1, ..., p4} parameter estimates
   \item \code{se.a0, se.a1, ..., se.p4} standard error of the parameter estimates
   \item \code{logLik} log-likelihood of the maximum likelihood estimates
 }
}
\description{
For each pair of rows in the data, underlying corelation (\eqn{\rho}) is calculated based on
   bivariate zero-inflated negative binomial (BZINB) model.
}
\examples{
# generating four random vectors
set.seed(7)
data1 <- rbzinb(n = 20, a0 = 0.5, a1 = 1, a2 = 1, 
                b1 = 1, b2 = 1, p1 = 0.5, p2 = 0.2, 
                p3 = 0.2, p4 = 0.1)
set.seed(14)
data2 <- rbzinb(n = 20, a0 = 0.5, a1 = 1, a2 = 1, 
                b1 = 2, b2 = 2, p1 = 0.5, p2 = 0.2, 
                p3 = 0.2, p4 = 0.1)
data3 <- t(cbind(data1, data2))

# calculating all pairwise underlying correlations
\dontrun{pairwise.bzinb(data3, showFlag = TRUE)}

}
\references{
Cho, H., Liu, C., Preisser, J., and Wu, D. (In preparation), "A bivariate 
 zero-inflated negative binomial model for identifying underlying dependence"
}
\author{
Hunyong Cho, Chuwen Liu, Jinyoung Park, and Di Wu
}
