% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_14sea.R, R/get_adrac.R, R/get_all_dates.R,
%   R/get_austarch.R, R/get_calpal.R, R/get_context.R, R/get_eastafrica.R,
%   R/get_euroevol.R, R/get_radon.R, R/get_radonb.R
\name{get_dates}
\alias{get_dates}
\alias{get_14SEA}
\alias{get_aDRAC}
\alias{get_all_dates}
\alias{get_AustArch}
\alias{get_CalPal}
\alias{get_CONTEXT}
\alias{get_KITEeastAfrica}
\alias{get_EUROEVOL}
\alias{get_RADON}
\alias{get_RADONB}
\title{Download radiocarbon source databases and convert them to a \strong{c14_date_list}}
\usage{
get_14SEA(db_url = get_db_url("14SEA"))

get_aDRAC(db_url = get_db_url("aDRAC"))

get_all_dates()

get_AustArch(db_url = get_db_url("AustArch"))

get_CalPal(db_url = get_db_url("CalPal"))

get_CONTEXT(db_url = get_db_url("CONTEXT"))

get_KITEeastAfrica(db_url = get_db_url("KITEeastAfrica"))

get_EUROEVOL(db_url = get_db_url("EUROEVOL"))

get_RADON(db_url = get_db_url("RADON"))

get_RADONB(db_url = get_db_url("RADON-B"))
}
\arguments{
\item{db_url}{weblink to c14 archive file. \code{c14bazAAR::get_db_url()} fetches the
current URL of the data source}
}
\description{
This functions download source databases and adjust their variables to conform to the
definition in \code{c14bazAAR::variable_reference}. That includes renaming and arranging
the variables (with \code{c14bazAAR::order_variables()}) as well as type conversion
(with \code{c14bazAAR::enforce_types()}) -- so all the steps undertaken by
\code{as.c14_date_list()}. \cr
All databases require different downloading and data wrangling steps. Therefore
there's a custom getter function for each of them. \cr
\code{get_all_dates()} is a wrapper to download all dates from all databases and
\code{c14bazAAR::fuse()} the results.
}
\examples{

\dontrun{
  aDRAC <- get_aDRAC()
  all_dates <- get_all_dates()
}

}
