% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{c3_gauge}
\alias{c3_gauge}
\title{Gauge Charts}
\usage{
c3_gauge(c3, label = NULL, min = 0, max = 100, units = NULL,
  width = NULL, pattern = c("#FF0000", "#F97600", "#F6C600", "#60B044"),
  threshold = list(unit = "value", max = 100, values = c(30, 60, 90, 100)),
  height = NULL, ...)
}
\arguments{
\item{c3}{c3 htmlwidget object}

\item{label}{list with options:
\itemize{
 \item{show}{: boolean}
 \item{format}{: function, wrap in JS() }
}}

\item{min}{numeric}

\item{max}{numeric}

\item{units}{character appended to numeric value}

\item{width}{integer pixel width of the arc}

\item{pattern}{character vector or pallete of colors}

\item{threshold}{list with options:
\itemize{
 \item{unit}{: character one of 'percent', 'value'}
 \item{max}{: numeric}
 \item{values}{: numeric vector of threhold values for color change}
}}

\item{height}{integer pixel height of the chart. Proprtion of guage
never changes so height scales with width despite this setting.}

\item{...}{additional values passed to the guage, color and size objects}
}
\value{
c3
}
\description{
Create simple Guage Charts
}
\examples{
data.frame(data=10) \%>\%
  c3() \%>\%
  c3_gauge(title = 'Colors')

}
