% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimators_paths.R
\name{estimatePath}
\alias{estimatePath}
\title{Internal: Estimate the structural coefficients}
\usage{
estimatePath(
 .approach_nl      = args_default()$.approach_nl,
 .approach_paths   = args_default()$.approach_paths,
 .csem_model       = args_default()$.csem_model,
 .H                = args_default()$.H,
 .normality        = args_default()$.normality,
 .P                = args_default()$.P,
 .Q                = args_default()$.Q
 )
}
\arguments{
\item{.approach_nl}{Character string. Approach used to estimate nonlinear
structural relationships. One of: "\emph{sequential}" or "\emph{replace}".
Defaults to "\emph{sequential}".}

\item{.approach_paths}{Character string. Approach used to estimate the
structural coefficients. One of: "\emph{OLS}" or "\emph{2SLS}". If "\emph{2SLS}", instruments
need to be supplied to \code{.instruments}. Defaults to "\emph{OLS}".}

\item{.csem_model}{A (possibly incomplete) \link{cSEMModel}-list.}

\item{.H}{The (N x J) matrix of construct scores.}

\item{.normality}{Logical. Should joint normality of
\eqn{[\eta_{1:p}; \zeta; \epsilon]}{[\eta_(1:p); \zeta; \epsilon]}
be assumed in the nonlinear model? See \insertCite{Dijkstra2014}{cSEM} for details.
Defaults to \code{FALSE}. Ignored if the model is not nonlinear.}

\item{.P}{A (J x J) construct variance-covariance matrix (possibly disattenuated).}

\item{.Q}{A vector of composite-construct correlations with element names equal to
the names of the J construct names used in the measurement model. Note
Q^2 is also called the reliability coefficient.}
}
\value{
A named list containing the estimated structural coefficients, the
R2, the adjusted R2, and the VIFs for each regression.
}
\description{
Estimates the coefficients of the structural model (nonlinear and linear) using
OLS, 2SLS. The latter currently work for linear models only.
}
\keyword{internal}
