% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Cextrap.R
\name{Cextrap}
\alias{Cextrap}
\title{Cextrap}
\usage{
Cextrap(param, crit, directions, longu, n)
}
\arguments{
\item{param}{: matrix [ NPoints , NPar ] of already evaluated parameters}

\item{crit}{: matrix [ Npoints , NObj ] of associated criteria}

\item{directions}{: matrix [ NDir, 2 ] the starting and ending points of the candidate vectors}

\item{longu}{: matrix [ NDir , 1 ] giving the length of each segment thus defined in the OBJ space (measure of the probability of exploring this direction)}

\item{n}{: number of new vectors to generate}
}
\value{
xnew : matrix [ n , NPar ] of new vectors

pcrit : matrix [ n , NObj ] estimated positions of new sets in the goal space
}
\description{
gives n new candidates by extrapolation along orthogonal directions to the Pareto front in the space of the objectives
}
\examples{
# Definition of the parameters
param <- matrix(rexp(100), 100, 1)
crit <- matrix(rexp(200), 100, 2)
directions <- matrix(c(1,3,2,7,13,40), nrow = 3, ncol = 2)
longu <- runif(3)
n <- 5
# Call the function
res <- Cextrap(param, crit, directions, longu, n)

}
\author{
Fabrice Zaoui
}
