% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calACSLoose.r
\name{calACSLoose}
\alias{calACSLoose}
\title{Calculate the total number of all common subsequences between a string and a vector/list of strings
Subsequences can be interrupted by items, i.e. q-w is a common subsequence of q-w-e-r and q-e-w-r}
\usage{
calACSLoose(vecA, listB, sep = "-", dropFirstItem = FALSE)
}
\arguments{
\item{vecA}{The single string}

\item{listB}{The vector/list of 1 or more strings}

\item{sep}{Delimiter separating each items in a sequence}

\item{dropFirstItem}{Boolean. If true, the first item in each sequence is excluded from counting all subsequences}
}
\value{
The total number of all common subsequences as an integer in a vector
}
\description{
Calculate the total number of all common subsequences between a string and a vector/list of strings
Subsequences can be interrupted by items, i.e. q-w is a common subsequence of q-w-e-r and q-e-w-r
}
\examples{
calACSLoose("q-w-e-r", c("q-e-w-r","q-r-e-w"), "-")
calACSLoose("itemToBeDropped-q-w-e-r", "itemToBeDroped-q-e-w-r", "-", dropFirstItem=TRUE)

}

